% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rExtremalStudentPar.R
\name{rExtremalStudentParetoProcess}
\alias{rExtremalStudentParetoProcess}
\title{Simulation of extremal Student generalized Pareto vectors}
\usage{
rExtremalStudentParetoProcess(
  n,
  Sigma,
  nu,
  normalize = FALSE,
  matchol = NULL,
  trunc = TRUE
)
}
\arguments{
\item{n}{sample size}

\item{Sigma}{a \code{d} by \code{d} correlation matrix}

\item{nu}{degrees of freedom parameter}

\item{normalize}{logical; should unit Pareto samples above \eqn{\kappa} be returned?}

\item{matchol}{Cholesky matrix \eqn{\mathbf{A}}{A} such that \eqn{\mathbf{A}\mathbf{A}^\top = \boldsymbol{\Sigma}}{AA^t = \Sigma}. Corresponds to \code{t(chol(Sigma))}. Default to \code{NULL}, in which case the Cholesky root is computed within the function.}

\item{trunc}{logical; should negative components be truncated at zero? Default to \code{TRUE}.}
}
\value{
an \code{n} by \code{d} matrix of samples, with \code{attributes} \code{"accept.rate"} indicating 
the fraction of samples accepted.
}
\description{
Simulation of Pareto processes associated to the max functional. The algorithm is described in section 4 of Thibaud and Opitz (2015). 
The Cholesky decomposition of the matrix \code{Sigma}
leads to samples on the unit sphere with respect to the Mahalanobis distance. 
An accept-reject algorithm is then used to simulate 
samples from the Pareto process. If \code{normalize = TRUE}, 
the vector is scaled by the exponent measure \eqn{\kappa} so that the maximum of the sample is greater than \eqn{\kappa}.
}
\note{
If \eqn{\nu>2}, an accept-reject algorithm using simulations from the angular measure on the
 \eqn{l_1}{l1} is at least twice as efficient. The relative efficiency of the latter is much larger for larger \eqn{\nu}. 
 This algorithm should therefore not be used in high dimensions as its acceptance rate
 is several orders of magnitude smaller than that implemented in \link[mev]{rparp}.
}
\examples{
loc <- expand.grid(1:4, 1:4)
Sigma <- exp(-as.matrix(dist(loc))^1.5)
rExtremalStudentParetoProcess(100, Sigma, nu = 2)
}
\references{
Thibaud, E. and T. Opitz (2015). Efficient inference and simulation for elliptical Pareto processes. Biometrika, 102(4), 855-870.
}
\seealso{
\link[mev]{rparp}
}
\author{
Emeric Thibaud, Leo Belzile
}
