/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.dialogs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.commons.widgets.WidgetFactory;
import org.af.jhlir.backends.rengine.RMatrixDoubleREngine;
import org.af.jhlir.call.RDataFrame;
import org.af.jhlir.call.RMatrixDouble;
import org.mutoss.Model;
import org.mutoss.MuTossControl;
import org.mutoss.gui.dialogs.StatMethodDialog;
import org.mutoss.gui.widgets.AnalysisDialogFactory;
import org.mutoss.gui.widgets.ContrastTable;
import org.mutoss.gui.widgets.GroupingBox;
import org.mutoss.gui.widgets.LevelOrderSL;
import org.mutoss.gui.widgets.ROptionBox;
import org.rosuda.REngine.REXPDouble;

public class ContrastDialog2
extends StatMethodDialog
implements ActionListener {
    private GroupingBox cbGroup;
    private LevelOrderSL slLevelOrder;
    private ROptionBox<String> cbType;
    private ContrastTable pTable;
    private JButton jbAdd;
    private JButton jbScaleCM;
    public JLabel jlInfo;

    public ContrastDialog2(JFrame window, RDataFrame df, Model model) {
        super(window, "Contrast Building", df);
        this.cbGroup = AnalysisDialogFactory.makeGroupingComboBox(df);
        this.slLevelOrder = AnalysisDialogFactory.makeLevelOrderSL(df, this.cbGroup);
        this.slLevelOrder.allToRight();
        this.jbAdd = new JButton("Add Contrast");
        this.jbAdd.addActionListener(this);
        this.jbScaleCM = new JButton("Scale contrasts");
        this.jbScaleCM.addActionListener(this);
        this.jlInfo = new JLabel("Please add contrasts.");
        this.pTable = new ContrastTable(df, this.cbGroup, this.slLevelOrder, this.jlInfo);
        String[] a = new String[]{"Dunnett", "Tukey", "Sequen", "AVE", "Changepoint", "Williams", "Marcus", "McDermott", "UmbrellaWilliams", "GrandMean"};
        String[] b = new String[]{"Dunnett", "Tukey", "Sequen", "AVE", "Changepoint", "Williams", "Marcus", "McDermott", "UmbrellaWilliams", "GrandMean"};
        this.cbType = new ROptionBox<String>("type", a, b);
        JPanel panel = new JPanel();
        panel.add(this.jbAdd);
        panel.add(this.jbScaleCM);
        Object[] labels = new String[]{"Type", null, "Contrasts", null};
        Component[] comps = new Component[]{this.cbType, panel, new JScrollPane((Component)((Object)this.pTable)), this.jlInfo};
        this.setContent(labels, comps);
        this.setModal(true);
        this.doTheLayout();
        this.pack();
        WidgetFactory.showCompleteTitle((JDialog)this);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    @Override
    protected void checkConstraints() {
        this.requiresFactVar();
    }

    public RMatrixDouble showAndGetMatrix() {
        this.setVisible(true);
        this.dispose();
        return this.getMatrix();
    }

    public RMatrixDouble getMatrix() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource().equals(this.jbAdd)) {
            RMatrixDouble m = this.getContrastMatrix(this.cbGroup.getSelectedItem().toString(), (String)this.cbType.getSelectedObject(), this.slLevelOrder.getRight());
            try {
                this.pTable.addMatrix(m);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource().equals(this.jbScaleCM)) {
            this.pTable.scale();
        }
    }

    public RMatrixDouble getContrastMatrix(String groupvarname, String type, List<String> list) {
        return new RMatrixDoubleREngine(MuTossControl.getR(), (REXPDouble)MuTossControl.getR().call("mutossGUI:::myContrMat", new Object[]{type, list, this.df, groupvarname}).getWrapped());
    }

    @Override
    protected void onOk() throws RemoteException {
        MuTossControl.getObj().setHypotheses(MuTossControl.getR().eval(this.pTable.getMatrix()));
        this.dispose();
    }
}

