% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{removeMismatchMut}
\alias{removeMismatchMut}
\title{Remove Mismatched Mutations.}
\usage{
removeMismatchMut(mutData, refMut_colName = "mutation",
  context_colName = "context", refMut_format = "N>N")
}
\arguments{
\item{mutData}{data.frame including mutation data, as well as the nucleotide
context around the mutated position}

\item{refMut_colName}{string, name of the column storing REF and VAR data. Defaults to "N>N"}

\item{context_colName}{string, name of the column storing nucleotide context around the variant.}

\item{refMut_format}{string, format of mutation types. Defaults to "N>N"}
}
\value{
filtered data.frame
}
\description{
Remove mutation types that do not match the expected nucleotidic context.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
x <- mutSignatures:::getTestRunArgs("removeMismatchMut")
y <- mutSignatures:::removeMismatchMut(x, 
                                       refMut_colName = "REF", 
                                       context_colName = "context", 
                                       refMut_format = "N")
y

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
