% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{evaluateStability}
\alias{evaluateStability}
\title{Evaluate Results Stability.}
\usage{
evaluateStability(wall, hall, params)
}
\arguments{
\item{wall}{numeric matrix including the w results from all the iterations of the analysis}

\item{hall}{numeric matrix including the h results from all the iterations of the analysis}

\item{params}{list including all the parameters required for running tha analysis}
}
\value{
list including all results from the stability checks.
This includes the most likely signatures (cen-troids) and exposures. 
All information for plotting the silhoueette plot will also be returned.
}
\description{
Perform a final Stability check comparing the results from all iterations of the analysis.
}
\details{
The function evaluates the results from all iterations by performing 
a silhouette check. A silhouette plot will also be plotted.
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is an internal function.
}
\examples{
# Obtain sample data
TMP <- mutSignatures:::getTestRunArgs("evaluateStability")
Y <- mutSignatures:::evaluateStability(wall = TMP$W, 
                                       hall = TMP$H, 
                                       params = TMP$params)


}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
