% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{msTrans_abs}
\alias{msTrans_abs}
\title{Multiscale quantile mapping bias correction}
\usage{
msTrans_abs(dta, agg_by = month, wet_int_thr = 0.1, maxiter = 10,
  tol = 1e-04, qstep = 0.001, period = c("G1", "Y1", "M3", "M1", "D1"))
}
\arguments{
\item{dta}{List with components \code{FROM} (simulated data for the control period), \code{TO} (observed data) and \code{NEWDATA} (data to be corrected). Each component is a \code{data.table} with columns \code{DTM} (date) and the climate variables (typically \code{PR} - precipitation and \code{TAS} - temperature)}

\item{agg_by}{Function for specification of the period (season, month) to be additionaly included in output, see Details}

\item{wet_int_thr}{Numeric value specifying the minimum depth to be considered wet}

\item{maxiter}{Maximum number of iterations, see Details}

\item{tol}{Stoping criterion of the iteration cycle, see Details}

\item{qstep}{A numeric value between 0 and 1. The quantile mapping is fitted only for the quantiles defined by quantile(0,1,probs=seq(0,1,by=qstep). Passed to \code{\link{doQmapQUANT}}.}

\item{period}{Specification of the aggregation lengths the correction is applied at with `D` - day(s), `M` - month(s), `Y` - year(s) and `G1` - the overall mean}
}
\value{
data.table with corrected data
}
\description{
Applies standard quantile mapping at custom time scales.
}
\details{
The procedure utilizes standard quantile mapping from the \code{\link{qmap}}-package, but at multiple time scales. Since correction at particular temporal scale influences values at other aggregations, the procedure is applied iterativelly until the maximum number of iterations (\code{maxiter}) is reached or the difference between succesive iteration step is smaller than \code{tol}. Differences between corrected and uncorrected variable at longer time scales are used to modify daily values after each iteration step (see e.g. Mehrorta and Sharma, 2016; Pegram et al. 2009). To make further assessment of the decomposed objects easier, indicator of period within the year (e.g. quarter or month) as specified by \code{agg_by} argument is included in the output.
}
\examples{
data("basin_PT")
scen = basin_PT$sim_scen
ctrl = basin_PT$sim_ctrl
obs = basin_PT$obs_ctrl
dta = list(TO = obs, FROM = ctrl, NEWDATA = scen)
\dontrun{
msTrans_abs(dta,  maxiter = 10, period = 'D1')
}
}
\references{
Hanel, M., Kozin, R., 2016. Bias and projected changes in climate model simulations at multiple time scales: consequences for hydrological impact assessment. Environmental Modelling and Software, submitted.

Mehrotra, R., Sharma, A., 2016. A multivariate quantile-matching bias correction approach with auto-and cross-dependence across multiple time scales: Implications for downscaling. Journal of Climate 29, 3519-3539.

Pegram, G.G., et al., 2009. A nested multisite daily rainfall stochastic generation model. Journal of Hydrology 371, 142-153.
}

