% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HFD.R
\name{HFD}
\alias{HFD}
\title{Higuchi's fractal dimension}
\usage{
HFD(P, k_max = 10)
}
\arguments{
\item{P}{A time series (numeric)}

\item{k_max}{Maximum window length in points}
}
\value{
A list with elements:\cr
\itemize{
\item \code{loglog} containing the log-log plot from which the HFD is calculated\cr
\item \code{Higuchi} containing the Higuchi's fractal dimension of the time series.
}
}
\description{
Higuchi's fractal dimension
}
\details{
For motor primitives, only the most linear part of the log-log plot should be used,
as reported in Santuz, Akay (2020).
}
\examples{
# Measurements of the annual flow of the river Nile at Aswan
flow <- datasets::Nile

# Calculate HFD
fractal_dimension <- HFD(flow)$Higuchi
message("Higuchi's fractal dimension: ", round(fractal_dimension, 3))

# Thirty-cycle locomotor primitive from Santuz & Akay (2020)
data(primitive)
fractal_dimension <- HFD(primitive$signal)$Higuchi
message("Higuchi's fractal dimension: ", round(fractal_dimension, 3))
}
\references{
Higuchi, T.
Approach to an irregular time series on the basis of the fractal theory.
Phys. D Nonlinear Phenom. 31, 277–283 (1988).\cr

Santuz, A. & Akay, T.
Fractal analysis of muscle activity patterns during locomotion: pitfalls and how to avoid them.
J. Neurophysiol. 124, 1083–1091 (2020).
}
