% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{multivariance.test}
\alias{multivariance.test}
\title{independence tests based on (total-/2-/3-) multivariance}
\usage{
multivariance.test(x, vec = 1:ncol(x), type = "total",
  p.value.type = "distribution_free", verbose = TRUE, ...)
}
\arguments{
\item{x}{either a data matrix or a list of centered distance matrices}

\item{vec}{if x is a matrix, then this indicates which columns are treated together as one sample; if x is a list, these are the indexes for which the multivariance is calculated. The default is all columns and all indexes, respectively.}

\item{type}{one of \code{"independence","pairwise independence","multi","total","m.multi.2","m.multi.3"}}

\item{p.value.type}{one of \code{"pearson_approx","distribution_free","resample"}}

\item{verbose}{logical, if TRUE meaningful text output is generated.}

\item{...}{these are passed to \code{\link{cdms}} (which is only invoked if \code{x} is a matrix)}
}
\value{
A list with class "\code{htest}" containing the following components:
\describe{
  \item{\code{statistic}}{the value of the test statistic,}
  \item{\code{p.value}}{the p-value of the test statistic,}
  \item{\code{method}}{a character string indicating the type of test performed,}
  \item{\code{data.name}}{a character string giving the name(s) of the data.}
}
}
\description{
This performs the (specified by \code{type} and \code{p.value.type}) independence test for the columns of a sample matrix.
}
\details{
The types \code{"independence"} and \code{"total"} are identical: an independence test is performed.

Also the types \code{"pairwise independence"} and \code{"m.multi.2"} are identical:  a test of pairwise independence is performed.

The type \code{"m.multi.3"}, performs a test for 3-independence, assuming pairwise independence. The type  \code{"multi"} performs a test for n-independence, assuming (n-1)-independence.

There are several ways (determined by \code{p.value.type}) to estimate the p-value: The \code{"pearson_approx"} and \code{"resample"} are approximately sharp. The latter is based on a resampling approach and thus much slower. The \code{"distribution_free"} test might be very conservative, its p-value estimates are only valid for p-values lower than 0.215 - values above should be interpreted as "values larger than 0.215".

All tests are performed using the standard euclidean distance. Other distances can be supplied via the \code{...}, see \code{\link{cdm}} for the accepted arguments.
}
\examples{
# an independence test
multivariance.test(dep_struct_several_26_100) # conservative
multivariance.test(dep_struct_several_26_100,p.value.type = "resample") #sharp but slow
multivariance.test(dep_struct_several_26_100,p.value.type = "pearson_approx") #

# as an example, all tests for one data set:
coins100 = coins(100)
for (ty in c("total","m.multi.2","m.multi.3","multi"))
 for (pvt in c("distribution_free","resample","pearson_approx"))
  print(multivariance.test(coins100,type=ty,p.value.type = pvt))


}
\references{
For the theoretic background see the references given on the main help page of this package: \link{multivariance-package}.
}
