% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{multivariance}
\alias{multivariance}
\title{distance multivariance}
\usage{
multivariance(x, vec = NA, Nscale = FALSE, correlation = FALSE, ...)
}
\arguments{
\item{x}{either a data matrix or an array of centered distance matrices}

\item{vec}{if x is a matrix, then this indicates which columns are treated together as one sample; if x is an array, these are the indexes for which the multivariance is calculated. The default is all columns and all indicies, respectively.}

\item{Nscale}{if \code{TRUE} the multivariance is scaled up by the sample size (and thus it is exactly as required for the test of independence). This is only used if \code{correlation = FALSE}.}

\item{correlation}{if \code{TRUE} the multivariance is normalized by norms of their centered distance matrices.}

\item{...}{these are passed to \code{\link{cdms}} (which is only invoked if \code{x} is a matrix)}
}
\description{
Computes the distance multivariance, either for given data or a given array of centered distance matrices.
}
\details{
If x is an matrix and vec is not given, then each column is treated as a separate sample. Otherwise vec has to have as many elements as x has columns and values starting from 1 up to the number of clusters. It computes the normalized multivariance, for a multivariance without normalization the argument \code{normalize = FALSE} has to be passed to \code{cdms}.

If x is an array, then vec has to be given.

\code{correlation = TRUE} yields values between 0 and 1. These can be interpreted similarly to classical correlations, see also \code{\link{multicorrelation}}.

For more details see the references given in the \link[=multivariance-package]{package documentation}.
}
\examples{
multivariance(matrix(rnorm(100*3),ncol = 3)) #independent sample
multivariance(coins(100)) #dependent sample which is 2-independent

x = matrix(rnorm(100*2),ncol = 2)
x = cbind(x,x[,2])
multivariance(x) #dependent sample which is not 2-independent
multivariance(x[,1:2]) #these are independent
multivariance(x[,2:3]) #these are dependent

multivariance(x[,2:3],correlation = TRUE)

}
