# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Estimate a Sparse Multiple-Subject Vector Autoregression (VAR) Model
#'
#' Function for estimating multiple-subjbect Vector Autoregression models
#' using Fast Iterative Shrinkage-Thresholding Algorithm (FISTA; Beck and Teboulle, 2009)
#'
#' @param A An N x P design matrix.
#' @param b An N x P outcome matrix.
#' @param lambda Regularization parameter.
#' @param x_true Numeric matrix containing the true transition matrix (if available).
#' @param niter Integer giving the maximum number of iterations.
#' @param backtrack Logical. If backtracking should be used in the FISTA algorithm.
#' @param w Numeric matrix containing the weights (if available).
#' @param conv Convergance criterion.
#' @details
#'
#' \strong{Function Under Development}
#'
#' This is a prototype function and is currently under development.
#'
#' @references
#'
#' Fisher, Z.F., Kim, Y., and Pipiras, V. (Under Review) Penalized
#' Estimation and Forecasting of Multiple Subject Intensive Longitudinal Data.
#'
#' Beck A. and Teboulle, M. (2009). A Fast Iterative Shrinkage-Thresholding
#' Algorithm for Linear Inverse Problems. SIAM J. Img. Sci. 2, 1, 183–202.
#'
#' @keywords var lasso
#'
#' @examples
#'
#' theta    <- matrix(rnorm(9),3,3)
#' data     <- var_sim(20, theta, diag(.1,3))
#' datalag  <- embed(data, 2)
#' b        <- datalag[,1:3]
#' A        <- datalag[,4:6]
#' fista_sparse(A, b, 1, theta, niter = 1, backtrack = TRUE)
#'
#'
#' @export
fista_sparse <- function(A, b, lambda, x_true, niter, backtrack, w = NULL, conv = 1e-10) {
    .Call(`_multivar_fista_sparse`, A, b, lambda, x_true, niter, backtrack, w, conv)
}

