% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msprep2.R
\name{msprep2}
\alias{msprep2}
\title{Converts long state entry data into a format suitable for multi-state modelling}
\usage{
msprep2(entry, tmat, censors = NULL, start_times = NULL,
  start_states = NULL, covars = NULL, idcol = "id")
}
\arguments{
\item{entry}{Long data frame of format \code{id} | \code{state} | \code{time}.
State can either be character, with the same state names used in \code{tmat}, or
integer where they refer to the rownumber of that state in \code{tmat}.
Note that the \code{state} and \code{time} fields must be labelled this way.}

\item{tmat}{Transition matrix in the standard format required by \code{msprep}.}

\item{censors}{A long data frame with 2 columns, \code{id} and \code{censor_time}.
Gives the last follow-up time for individuals that haven't entered a sink state.}

\item{start_times}{A long data frame with 2 columns, \code{id} and \code{start_time}.
Gives the time at which the patient entered the simulation. Defaults to 0.}

\item{start_states}{A long data frame with 2 columns, \code{id} and \code{start_state}.
Gives the state the patient entered the simulation in. Defaults to 1.}

\item{covars}{Data frame where each row corresponds to an individual and details their
covariate values. Must contain the id column specified in \code{idcol} alongside
any covariate fields of interest.}

\item{idcol}{The column that indexes these patients, must be present in
\code{entry} and \code{censors}, \code{start_times}, \code{start_states},
and \code{covars} if supplied.}
}
\value{
An object of class \code{msdata}, representing the transition data
  in long format.
}
\description{
This function performs the same role as \code{msprep} from the \code{mstate} package, except
that it accepts long data (each row corresponds to a state entry) rather
than the wide format used by \code{msprep} (each row represents an individual with state entry
indicated in columns).
}
\details{
The long data format required by \code{msprep2} is a more natural way of organising
state entry data than the wide format required by \code{msprep}.
An additional benefit of having the state entries organised in this fashion is that
it allows for the situation where an individual enters the same state multiple times,
which is not supported by \code{msprep}.
}
\examples{
 library(multistateutils)
 library(mstate)

 tmat <- trans.illdeath()
 entry <- data.frame(id=c(1, 2, 2),
                     state=c(2, 2, 3),
                     time=c(23, 35, 360))

 msprep2(entry, tmat)
}
