% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_dic-class.R
\name{plot.nma_dic}
\alias{plot.nma_dic}
\title{Plots of model fit diagnostics}
\usage{
\method{plot}{nma_dic}(
  x,
  y,
  ...,
  type = c("resdev", "leverage"),
  show_uncertainty = TRUE,
  stat = "pointinterval",
  orientation = c("vertical", "horizontal", "x", "y"),
  dic_contours = 1:4
)
}
\arguments{
\item{x}{A \code{nma_dic} object}

\item{y}{(Optional) A second \code{nma_dic} object, to produce "dev-dev" plots for
model comparison.}

\item{...}{Additional arguments passed on to other methods}

\item{type}{With a single \code{nma_dic} object, whether to show the residual
deviance contribution for each data point (\code{"resdev"}, the default), or a
leverage plot (\code{"leverage"}).}

\item{show_uncertainty}{Logical, show uncertainty with a \code{ggdist} plot
stat? Default \code{TRUE}. Ignored for \code{type = "leverage"}.}

\item{stat}{Character string specifying the \code{ggdist} plot stat to use if
\code{show_uncertainty = TRUE}, default \code{"pointinterval"}. If \code{y} is provided,
currently only \code{"pointinterval"} is supported.}

\item{orientation}{Whether the \code{ggdist} geom is drawn horizontally
(\code{"horizontal"}) or vertically (\code{"vertical"}). Only used for residual
deviance plots, default \code{"vertical"}.}

\item{dic_contours}{Numeric vector of DIC contribution contours to show on
leverage plots, default \code{1:4}.}
}
\value{
A \code{ggplot} object.
}
\description{
The \code{plot()} method for \link{nma_dic} objects produced by \code{\link[=dic]{dic()}} produces
several useful diagnostic plots for checking model fit and model comparison.
Further detail on these plots and their interpretation is given by
\insertCite{TSD2;textual}{multinma}.
}
\details{
When a single \code{nma_dic} object is given, the default plot (\code{type = "resdev"}) shows the residual deviance contribution for each data point.
For a good fitting model, each data point is expected to have a residual
deviance equal to its degrees of freedom (typically 1, except for multi-arm
trials in contrast format or multinomial outcomes); larger values indicate
data points that are fit poorly by the model. A leverage plot can be
produced with \code{type = "leverage"}, plotting the leverages (contributions to
\eqn{p_D}) against the signed square root residual deviance, both
standardised by the degrees of freedom. Contours for different DIC
contribution cutoffs are also shown; points which lie outside the DIC=3
contour are generally identified as contributing to a model's poor fit.

When two \code{nma_dic} objects are given, a "dev-dev" plot comparing the
residual deviance contributions under each model is produced. Data points
with residual deviance contributions lying on the line of equality are fit
equally well under either model. Data points lying below the line of
equality indicate better fit under the second model (\code{y}); conversely, data
points lying above the line of equality indicate better fit under the first
model (\code{x}). A common use case is to compare a standard consistency model
(fitted using \code{\link[=nma]{nma()}} with \code{consistency = "consistency"}) with an unrelated
mean effects (UME) inconsistency model (fitted using \code{\link[=nma]{nma()}} with
\code{consistency = "ume"}), to check for potential inconsistency.

See \insertCite{TSD2;textual}{multinma} for further details.
}
\examples{
## Smoking cessation
\donttest{
# Run smoking FE NMA example if not already available
if (!exists("smk_fit_FE")) example("example_smk_fe", run.donttest = TRUE)
}
\donttest{
# Run smoking RE NMA example if not already available
if (!exists("smk_fit_RE")) example("example_smk_re", run.donttest = TRUE)
}
\donttest{
# Compare DIC of FE and RE models
(smk_dic_FE <- dic(smk_fit_FE))
(smk_dic_RE <- dic(smk_fit_RE))   # substantially better fit

# Plot residual deviance contributions under RE model
plot(smk_dic_RE)

# Further customisation is possible using ggplot commands
# For example, highlighting data points with residual deviance above a certain threshold
plot(smk_dic_RE) +
  ggplot2::aes(colour = ggplot2::after_stat(ifelse(y > 1.5, "darkorange", "black"))) +
  ggplot2::scale_colour_identity()

# Or by posterior probability, for example here a central probability of 0.6
# corresponds to a lower tail probability of (1 - 0.6)/2 = 0.2
plot(smk_dic_RE, .width = c(0.6, 0.95)) +
  ggplot2::aes(colour = ggplot2::after_stat(ifelse(ymin > 1, "darkorange", "black"))) +
  ggplot2::scale_colour_identity()

# Leverage plot for RE model
plot(smk_dic_RE, type = "leverage")

# Check for inconsistency using UME model
}
\donttest{
# Run smoking UME NMA example if not already available
if (!exists("smk_fit_RE_UME")) example("example_smk_ume", run.donttest = TRUE)
}
\donttest{
# Compare DIC
smk_dic_RE
(smk_dic_RE_UME <- dic(smk_fit_RE_UME))  # no difference in fit

# Compare residual deviance contributions with a "dev-dev" plot
plot(smk_dic_RE, smk_dic_RE_UME)

# By default the dev-dev plot can be a little cluttered
# Hiding the credible intervals
plot(smk_dic_RE, smk_dic_RE_UME, show_uncertainty = FALSE)

# Changing transparency
plot(smk_dic_RE, smk_dic_RE_UME, point_alpha = 0.5, interval_alpha = 0.1)
}
}
\references{
\insertAllCited{}
}
