% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data.R
\name{set_agd_surv}
\alias{set_agd_surv}
\title{Set up aggregate survival data}
\usage{
set_agd_surv(
  data,
  study,
  trt,
  Surv,
  covariates = NULL,
  trt_ref = NULL,
  trt_class = NULL
)
}
\arguments{
\item{data}{a data frame}

\item{study}{column of \code{data} specifying the studies, coded using integers,
strings, or factors}

\item{trt}{column of \code{data} specifying treatments, coded using integers,
strings, or factors}

\item{Surv}{column of \code{data} specifying a survival or time-to-event outcome,
using the \code{\link[=Surv]{Surv()}} function. Right/left/interval censoring and left
truncation (delayed entry) are supported.}

\item{covariates}{data frame of covariate summary statistics for each study
or study arm, with corresponding \code{study} and \code{trt} columns to match to
those in \code{data}}

\item{trt_ref}{reference treatment for the network, as a single integer,
string, or factor. If not specified, a reasonable well-connected default
will be chosen (see details).}

\item{trt_class}{column of \code{data} specifying treatment classes, coded using
integers, strings, or factors. By default, no classes are specified.}
}
\value{
An object of class \link{nma_data}
}
\description{
Set up a network containing aggregate survival data (AgD) in the form of
event/censoring times (e.g. reconstructed from digitized Kaplan-Meier curves)
and covariate summary statistics from each study. Multiple data sources may be
combined once created using \code{\link[=combine_network]{combine_network()}}.
}
\details{
By default, \code{trt_ref = NULL} and a network reference treatment will be chosen
that attempts to maximise computational efficiency and stability. If an
alternative reference treatment is chosen and the model runs slowly or has
low effective sample size (ESS) this may be the cause - try letting the
default reference treatment be used instead. Regardless of which treatment is
used as the network reference at the model fitting stage, results can be
transformed afterwards: see the \code{trt_ref} argument of
\code{\link[=relative_effects]{relative_effects()}} and \code{\link[=predict.stan_nma]{predict.stan_nma()}}.

All arguments specifying columns of \code{data} accept the following:
\itemize{
\item A column name as a character string, e.g. \code{study = "studyc"}
\item A bare column name, e.g. \code{study = studyc}
\item \code{dplyr::mutate()} style semantics for inline variable transformations, e.g. \code{study = paste(author, year)}
}
}
\examples{
## Newly diagnosed multiple myeloma

head(ndmm_agd)  # Reconstructed Kaplan-Meier data
ndmm_agd_covs   # Summary covariate information on each arm

set_agd_surv(ndmm_agd,
             study = studyf,
             trt = trtf,
             Surv = Surv(eventtime, status),
             covariates = ndmm_agd_covs)

}
\seealso{
\code{\link[=set_ipd]{set_ipd()}} for individual patient data, \code{\link[=set_agd_contrast]{set_agd_contrast()}} for
contrast-based aggregate data, and \code{\link[=combine_network]{combine_network()}} for combining
several data sources in one network.

\code{\link[=print.nma_data]{print.nma_data()}} for the print method displaying details of the
network, and \code{\link[=plot.nma_data]{plot.nma_data()}} for network plots.
}
