% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data-class.R
\name{is_network_connected}
\alias{is_network_connected}
\title{Check network connectedness}
\usage{
is_network_connected(network)
}
\arguments{
\item{network}{An \code{nma_data} object, as created by the functions \verb{set_*()} or
\code{combine_network()}.}
}
\value{
Logical \code{TRUE} or \code{FALSE}
}
\description{
Check whether a network is connected - whether there is a path of study
evidence linking every pair of treatments in the network.
}
\details{
Models will still run with disconnected networks. However, estimated
relative effects between treatments across disconnected parts of the
network will be entirely based on the prior distribution (typically very
uncertain), as there is no information to update the prior distribution.
Relative effects within each connected sub-network will be estimated as if
each sub-network had been analysed separately.
}
\examples{
## Smoking cessation
# Set up network of smoking cessation data
head(smoking)

smk_net <- set_agd_arm(smoking,
                       study = studyn,
                       trt = trtc,
                       r = r,
                       n = n,
                       trt_ref = "No intervention")

# Print details
smk_net

is_network_connected(smk_net)  # TRUE, network is connected
## A disconnected network
disc_net <- set_agd_arm(smoking[smoking$studyn \%in\% c(15, 21), ],
                        study = studyn,
                        trt = trtc,
                        r = r,
                        n = n)
is_network_connected(disc_net)  # FALSE, network is disconnected
disc_net
plot(disc_net)
}
