% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_prior-class.R
\name{summary.nma_prior}
\alias{summary.nma_prior}
\title{Summary of prior distributions}
\usage{
\method{summary}{nma_prior}(object, ..., probs = c(0.5, 0.95), digits = 2, trunc = NULL)
}
\arguments{
\item{object}{Prior distribution as a \code{nma_prior} object}

\item{...}{Additional arguments, not used}

\item{probs}{Numeric vector of probabilities to calculate prior intervals}

\item{digits}{Number of digits to display}

\item{trunc}{Optional numeric vector of length 2, giving the truncation
limits of the prior distribution. Useful if a real-valued prior is assigned
to a positive-valued parameter, then \code{trunc = c(0, Inf)} will give the
correct prior intervals. By default, truncation is not used.}
}
\value{
A data frame is returned invisibly, giving the prior intervals
}
\description{
Print a summary of prior distribution details.
}
\examples{
summary(normal(location = 0, scale = 1))
summary(half_normal(scale = 1))
summary(log_normal(location = -3.93, scale = 1.51))

# Truncation limits may be set, for example to restrict a prior to positive values
summary(normal(location = 0.5, scale = 1), trunc = c(0, Inf))

}
