% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClosedSCR.R
\name{getprobsClosedSCR}
\alias{getprobsClosedSCR}
\title{Calculate posterior capture and recapture probabilities}
\usage{
getprobsClosedSCR(out, link = "cloglog")
}
\arguments{
\item{out}{List of output returned by \code{\link{multimarkClosedSCR}}.}

\item{link}{Link function for detection probability. Must be "\code{cloglog}". Note that \code{\link{multimarkClosedSCR}} is currently implemented for the cloglog link only.}
}
\value{
An object of class \code{\link[coda]{mcmc.list}} containing the following:
\item{p}{Posterior samples for capture probability (\eqn{p}) for each sampling occasion (first index) and trap (second index).}
\item{c}{Posterior samples for recapture probability (\eqn{c}) for each sampling occasion (first index) and trap (second index).}
}
\description{
This function calculates posterior spatial capture (\eqn{p}) and recapture (\eqn{c}) probabilities (at zero distance from an activity center) for each sampling occasion from \code{\link{multimarkClosedSCR}} output.
}
\examples{
\dontshow{
sim.data<-simdataClosedSCR()
Enc.Mat<-sim.data$Enc.Mat
trapCoords<-sim.data$spatialInputs$trapCoords
studyArea<-sim.data$spatialInputs$studyArea
test<-getprobsClosedSCR(multimarkClosedSCR(Enc.Mat,trapCoords,studyArea,iter=10,burnin=0,bin=5))}
\donttest{
# This example is excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

#Run behavior model for simulated data with constant detection probability (i.e., mod.p=~c)
sim.data<-simdataClosedSCR()
Enc.Mat<-sim.data$Enc.Mat
trapCoords<-sim.data$spatialInputs$trapCoords
studyArea<-sim.data$spatialInputs$studyArea
example.c <- multimarkClosedSCR(Enc.Mat,trapCoords,studyArea,mod.p=~c,
                                iter=1000,adapt=500,burnin=500)
  
#Calculate capture and recapture probabilities
pc <- getprobsClosedSCR(example.c)
summary(pc)}

}
\seealso{
\code{\link{multimarkClosedSCR}}
}
\author{
Brett T. McClintock
}
