% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/CJS.R
\name{simdataCJS}
\alias{simdataCJS}
\title{Simulate open population capture-mark-recapture data arising from multiple non-invasive marks}
\usage{
simdataCJS(N = 100, noccas = 5, pbeta = -0.25, sigma2_zp = 0,
  phibeta = 1.6, sigma2_zphi = 0, delta_1 = 0.4, delta_2 = 0.4,
  alpha = 0.5, data.type = "never", link = "probit")
}
\arguments{
\item{N}{Number of individuals.}

\item{noccas}{Number of sampling occasions. \code{floor(N/noccas)} individuals are first encountered on each occasion.}

\item{pbeta}{Logit- or probit-scale intercept term(s) for capture probability (p). Must be a scaler or vector of length \code{noccas}.}

\item{sigma2_zp}{Logit- or probit-scale individual heterogeneity variance term for capture probability (p).}

\item{phibeta}{Logit- or probit-scale intercept term(s) for survival probability (\eqn{\phi}). Must be a scaler or vector of length \code{noccas}.}

\item{sigma2_zphi}{Logit- or probit-scale individual heterogeneity variance term for survival probability (\eqn{\phi}).}

\item{delta_1}{Conditional probability of type 1 encounter, given detection.}

\item{delta_2}{Conditional probability of type 2 encounter, given detection.}

\item{alpha}{Conditional probability of simultaneous type 1 and type 2 detection, given both types encountered. Only applies when \code{data.type="sometimes"}.}

\item{data.type}{Specifies the encounter history data type. All data types include non-detections (type 0 encounter), type 1 encounter (e.g., left-side), and type 2 encounters (e.g., right-side). When both type 1 and type 2 encounters occur for the same individual within a sampling occasion, these can either be "non-simultaneous" (type 3 encounter) or "simultaneous" (type 4 encounter). Three data types are currently permitted:

 \code{data.type="never"} indicates both type 1 and type 2 encounters are never observed for the same individual within a sampling occasion, and observed encounter histories therefore include only type 1 or type 2 encounters (e.g., only left- and right-sided photographs were collected). Observed encounter histories can consist of non-detections (0), type 1 encounters (1), and type 2 encounters (2). See \code{\link{bobcat}}. Latent encounter histories consist of non-detections (0), type 1 encounters (1), type 2 encounters (2), and type 3 encounters (3).

 \code{data.type="sometimes"} indicates both type 1 and type 2 encounters are sometimes observed (e.g., both-sided photographs are sometimes obtained, but not necessarily for all individuals). Observed encounter histories can consist of non-detections (0), type 1 encounters (1), type 2 encounters (2), type 3 encounters (3), and type 4 encounters (4). Type 3 encounters can only be observed when an individual has at least one type 4 encounter. Latent encounter histories consist of non-detections (0), type 1 encounters (1), type 2 encounters (2), type 3 encounters (3), and type 4 encounters (4).

 \code{data.type="always"} indicates both type 1 and type 2 encounters are always observed, but some encounter histories may still include only type 1 or type 2 encounters. Observed encounter histories can consist of non-detections (0), type 1 encounters (1), type 2 encounters (2), and type 4 encounters (4). Latent encounter histories consist of non-detections (0), type 1 encounters (1), type 2 encounters (2), and type 4 encounters (4).}

\item{link}{Link function for detection probability. Must be "\code{logit}" or "\code{probit}". Note that \code{\link{multimarkCJS}} is currently implemented for the probit link only.}
}
\value{
A list containing the following:
\item{Enc.Mat}{A matrix containing the observed encounter histories with rows corresponding to individuals and columns corresponding to sampling occasions.}
\item{trueEnc.Mat}{A matrix containing the true (latent) encounter histories with rows corresponding to individuals and columns corresponding to sampling occasions.}
}
\description{
This function generates encounter histories from simulated open population capture-mark-recapture data consisting of multiple non-invasive marks.
}
\examples{
#simulate data for data.type="sometimes" using defaults
data<-simdataCJS(data.type="sometimes")
}
\author{
Brett T. McClintock
}
\references{
Bonner, S. J., and Holmberg J. 2013. Mark-recapture with multiple, non-invasive marks. \emph{Biometrics} 69: 766-775.

McClintock, B. T., Conn, P. B., Alonso, R. S., and Crooks, K. R. 2013. Integrated modeling of bilateral photo-identification data in mark-recapture analyses. \emph{Ecology} 94: 1464-1471.
}
\seealso{
\code{\link{processdata}}, \code{\link{multimarkCJS}}
}

