% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.modelDiagnostics.lme}
\alias{plot.modelDiagnostics.lme}
\title{Plot Diagnostics for an lme model}
\usage{
\method{plot}{modelDiagnostics.lme}(x, y, plot = TRUE, ask = TRUE, ncol = 1, nrow = 1, ...)
}
\arguments{
\item{x}{A fitted model object from \code{lme()}.}

\item{y}{Included to match the generic. Not used.}

\item{plot}{A logical value whether or not to plot the results or
simply return the graaphical  objects.}

\item{ask}{A logical whether to ask before changing plots.
Only applies to interactive environments.}

\item{ncol}{The number of columns to use for plots.
Defaults to 1.}

\item{nrow}{The number of rows to use for plots.
Defaults to 1.}

\item{...}{Included to match the generic. Not used.}
}
\value{
a list including plots of the residuals,
  residuals versus fitted values, and one list for
  plots of all random effects
}
\description{
This function creates a number of diagnostic plots
from lme models.
}
\examples{

library(JWileymisc)
sleep[1,1] <- NA
m <- nlme::lme(extra ~ group, data = sleep, random = ~ 1 | ID, na.action = "na.omit")

md <- modelDiagnostics(m, ev.perc = .1)
md$extremeValues

plot(md)

data(aces_daily, package = "JWileymisc")
m <- nlme::lme(PosAff ~ STRESS, data = aces_daily,
  random = ~ 1 + STRESS | UserID, na.action = "na.omit")

md <- modelDiagnostics(m, ev.perc = .001)
md$extremeValues
plot(md$modelDiagnostics[[2]][[2]])
plot(md, ncol = 2, nrow = 2)
plot(md, ncol = 2, nrow = 3)

rm(m, md, sleep)
}
\keyword{plot}
