% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGC.R
\name{BGC}
\alias{BGC}
\title{Between Group Comparison}
\usage{
BGC(Data, Group, numc = NULL, ncomp = NULL, Scale = FALSE, graph = FALSE)
}
\arguments{
\item{Data}{a numeric matrix or data frame}

\item{Group}{a vector of factors associated with group structure}

\item{numc}{number of components assocaited with PCA on each group}

\item{ncomp}{number of components, if NULL number of components is equal to 2}

\item{Scale}{scaling variables, by defalt is FALSE. By default data are centered within groups}

\item{graph}{should loading and component be plotted}
}
\value{
list with the following results:

\item{Data       }{Original data}

\item{Con.Data       }{Concatenated centered data}

\item{split.Data       }{Group centered data}

\item{Group       }{Group as a factor vector}

\item{loadings.common       }{Matrix of common loadings}

\item{lambda       }{The specific variances of groups}

\item{exp.var       }{Percentages of total variance recovered associated with each dimension }
}
\description{
Between Group Comparison (BGC)
}
\examples{
Data = iris[,-5]
Group = iris[,5]
res.BGC = BGC(Data, Group, graph=TRUE)
loadingsplot(res.BGC, axes=c(1,2))
scoreplot(res.BGC, axes=c(1,2)) 
}
\references{
W. J. Krzanowski (1979). Between-groups comparison of principal components,
 \emph{Journal of the American Statistical Association}, 74, 703-707.

A. Eslami, E. M. Qannari, A. Kohler and S. Bougeard (2013). General overview
 of methods of analysis of multi-group datasets,
 \emph{Revue des Nouvelles Technologies de l'Information}, 25, 108-123.

A. Eslami, E. M. Qannari, A. Kohler and S. Bougeard (2013). Analyses
factorielles de donnees structurees en groupes d'individus,
\emph{Journal de la Societe Francaise de Statistique}, 154(3), 44-57.
}
\seealso{
\code{\link{mgPCA}}, \code{\link{FCPCA}}, \code{\link{DCCSWA}}, 
\code{\link{DSTATIS}}, \code{\link{DGPA}}, \code{\link{summarize}},
 \code{\link{TBWvariance}}, \code{\link{loadingsplot}}, 
 \code{\link{scoreplot}}, \code{\link{iris}}
}
