% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_pooled_sd.R
\name{d_pooled_sd}
\alias{d_pooled_sd}
\title{Standardized mean difference with pooled standard deviation}
\usage{
d_pooled_sd(
  data,
  var,
  group.var,
  group.values,
  rename.output = TRUE,
  infer = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{var}{A continuous variable for which difference is estimated.}

\item{group.var}{The name of the group variable.}

\item{group.values}{Vector of length 2, group values (e.g. c("male", "female) or c(0,1)).}

\item{rename.output}{Logical. Should the output values be renamed according to the group.values? Default TRUE.}

\item{infer}{Logical. Statistical inference with Welch test? (default FALSE)}
}
\value{
Descriptive statistics and mean differences
}
\description{
Standardized mean difference with pooled standard deviation
}
\examples{
d_pooled_sd(iris[iris$Species == "setosa" | iris$Species == "versicolor", ],
  var = "Petal.Length", group.var = "Species",
  group.values = c("setosa", "versicolor"), infer = TRUE
)
}
