% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicross.R
\name{mcm}
\alias{mcm}
\title{Multisample generalization of Rosenbaum's crossmatch test}
\usage{
mcm(data_list, level)
}
\arguments{
\item{data_list}{is list of multifeature matrices corresponding to the K different classes, so each element of the list is a matrix, for a total of K matrices. Each matrix contains observations as the rows and features as the columns}

\item{level}{is the level alpha for hypothesis testing}
}
\value{
The p-value corresponding to rejection of the alternative, along with the decision of the hypothesis testing (Null being accepted versus rejected)
}
\description{
In this packcage, we present a framework inspired by Rosenbaum's crossmatch idea to tackle the nonparametric, multisample problem wherein one is concerned with testing the equality of K unknown multivariate probability distributions.
We implement two tests: the first is a multisample generalization of Rosenbaum's crossmatch (MCM), and the other further introduces a Malahnobis-type modification to the test (MMCM).
}
\examples{
# Simulation Example when the user wants to test whether K=3 multivariate distributions are equal:
X1 = MASS::mvrnorm(10,rep(0,4),diag(2,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
X2 = MASS::mvrnorm(10,rep(0,4),diag(1,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
X3 = MASS::mvrnorm(10,rep(0,4),diag(3,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
mcm(list(X1,X2,X3),0.05)
}
