% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_eaf_to_tsv.R
\name{mc_eaf_to_tsv}
\alias{mc_eaf_to_tsv}
\title{Convert EAF files to TSV (WIP)}
\usage{
mc_eaf_to_tsv(readfrom = getwd(), recursive = FALSE, split = FALSE,
  write = FALSE, writeto = getwd(), filename = "")
}
\arguments{
\item{readfrom}{Directory from which to read EAF files. Defaults to the
current working directory.}

\item{recursive}{Logical. If \code{TRUE}, the function recurses into
subdirectories.}

\item{split}{Logical. If \code{FALSE}, all EAF files that are read are bound
into a single data table. If \code{TRUE}, a list of data tables is returned
instead, with one list item per text (which may be split across multiple
EAF files). If \code{write} is \code{TRUE}, written output is either a
single TSV file (for \code{split == TRUE}) or one TSV file per text read
(for \code{split == FALSE}). In the latter case TSV files combining all
texts from each corpus are also produced.}

\item{write}{Logical. If \code{TRUE}, also creates output in \code{TSV}
format.}

\item{writeto}{A directory to which to write output. Defaults to
\code{getwd}. Ignored if \code{write} is \code{FALSE}.}

\item{filename}{A length 1 character vector containing the name of the
written output. If empty, defaults to "multicast_YYMM", where 'YY' are the
last two digits of the current year and 'MM' the current month. Ignored if
\code{write} is \code{FALSE} and/or if \code{split} is \code{TRUE}, as in
the latter case file names are instead generated from text metadata.}
}
\value{
Either a \code{\link[data.table]{data.table}} or \code{list} of
  \code{data.table}s of the form produced by \code{\link{multicast}},
  containing the annotation values of the EAF files read.
}
\description{
\code{mc_eaf_to_tsv} converts EAF files produced by the linguistic annotation
software ELAN into one or multiple tab-separated values (TSV) tables. The EAF
files must have the correct tier structure with the correct tier names, or
conversion fails. See the Multi-CAST documentation for details. File are
added to the TSV table in the alphabetical order of their file names.
}
\examples{
\dontrun{
  # read all EAF files in the current working directory,
  # returns a data table of the kind accessed by multicast()
  mc_eaf_to_tsv()

  # also produce a file 'mydata.tsv' containing all read data
  mc_eaf_to_tsv(write = TRUE, filename = "mydata")

  # instead of a single monolithic table, return a list
  # of tables and produce one TSV file for each text
  mc_eaf_to_tsv(write = TRUE, split = TRUE)
}

}
\keyword{internal}
