% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_journals.R
\docType{data}
\name{journals}
\alias{journals}
\title{Prevalence of Statistical Reporting Errors}
\format{
A \code{data.frame} with 8 rows and 14 variables:\tabular{ll}{
   Variable Name \tab Description \cr
   \code{journal} \tab The journal name a research article was published in. \cr
   \code{articles_downloaded} \tab The number of articles downloaded per journal. \cr
   \code{articles_with_NHST} \tab The number of articles with NHST results. \cr
   \code{perc_articles_with_NHST} \tab The percentage of all downloaded articles that had NHST results. \cr
   \code{nr_NHST} \tab The total number of NHST results. \cr
   \code{mean_nr_NHST_per_article_with_NHST} \tab The mean number of NHST results per article that had at least one NHST result. \cr
   \code{mean_nr_NHST_per_article_all_included} \tab The mean number of NHST results in all downloaded articles. \cr
   \code{errors} \tab The total number of errors. \cr
   \code{dec_errors} \tab The total number of decision errors (i.e., an error that may have changed the statistical conclusion of the result). \cr
   \code{perc_errors} \tab The percentage of all results that was an error. \cr
   \code{perc_dec_errors} \tab The percentage of all results that was a decision error. \cr
   \code{perc_articles_with_errors} \tab The percentage of all articles that had at least one error. \cr
   \code{perc_articles_with_dec_errors} \tab The percentage of all articles that had at least one error. \cr
   \code{APAfactor} \tab APA factor: number of detected NHST results / total number of detected p values. \cr
}
}
\usage{
data(journals)
}
\description{
This data set, "journals" provides a summary of statistical reporting errors (i.e., inconsistencies between reported test statistic
and reported p-value) of 16,695 research articles reporting results
from null hypothesis significance testing (NHST). The selected articles were published in
eight major journals in psychology between 1985 to 2013:
\itemize{
\item \emph{Developmental Psychology} (DP)
\item \emph{Frontiers in Psychology} (FP)
\item \emph{Journal of Applied Psychology} (JAP)
\item \emph{Journal of Consulting and Clinical Psychology} (JCCP)
\item \emph{Journal of Experimental Psychology: General} (JEPG)
\item \emph{Journal of Personality and Social Psychology} (JPSP)
\item \emph{Public Library of Science} (PLoS)
\item \emph{Psychological Science} (PS)
}

In total, Nuijten et al. (2016) recomputed 258,105 p-values with the \code{R} software
package \code{statcheck} which extracts statistics from articles and recomputes the p-values.
The anonymized dataset and the data documentation was openly available on the
Open Science Framework (\url{https://osf.io/d3ukb/}; \url{https://osf.io/c6ap2/}).
}
\examples{
data(journals)
# Prior specification 
# We assign a uniform Beta distribution on each binomial probability
a <- rep(1, 8)  
b <- rep(1, 8)  

x <- journals$errors 
n  <- journals$nr_NHST
factor_levels <- levels(journals$journal)

# restricted hypothesis
Hr1 <- c('JAP , PS , JCCP , PLOS , DP , FP , JEPG < JPSP')
out <- binom_bf_informed(x=x, n=n, Hr=Hr1, a=a, b=b, 
factor_levels=factor_levels, niter = 2e3)

summary(out)
}
\references{
\insertRef{nuijten2016prevalence}{multibridge}
}
\keyword{datasets}
