% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{basic}
\alias{basic}
\title{Single- and Two-Block Methods}
\description{
This documentation covers a range of single- and two-block methods. In particular:
\itemize{
\item PCA - Principal Component Analysis (\code{\link{pca}})
\item PCR - Principal Component Regression (\code{\link{pcr}})
\item PLSR - Partial Least Squares Regression (\code{\link{plsr}})
\item CCA - Canonical Correlation Analysis (\code{\link{cca}})
\item IFA - Interbattery Factor Analysis (\code{\link{ifa}})
\item GSVD - Generalized SVD (\code{\link{gsvd}})
}
}
\examples{
data(potato)
X <- potato$Chemical
y <- potato$Sensory[,1,drop=FALSE]

pca.pot  <- pca(X, ncomp = 2)
pcr.pot  <- pcr(y ~ X, ncomp = 2)
pls.pot  <- plsr(y ~ X, ncomp = 2)
cca.pot  <- cca(potato[1:2])
ifa.pot  <- ifa(potato[1:2])
gsvd.pot <- gsvd(lapply(potato[3:4], t))

}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
