% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_uc_sel.R
\name{adjust_uc_sel}
\alias{adjust_uc_sel}
\title{Adust for uncontrolled confounding and selection bias.}
\usage{
adjust_uc_sel(
  data,
  exposure,
  outcome,
  confounders = NULL,
  u_model_coefs,
  s_model_coefs,
  level = 0.95
)
}
\arguments{
\item{data}{Dataframe for analysis.}

\item{exposure}{String name of the exposure variable.}

\item{outcome}{String name of the outcome variable.}

\item{confounders}{String name(s) of the confounder(s).
A maximum of three confounders is allowed.}

\item{u_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(U=1)) = &alpha;<sub>0</sub> + &alpha;<sub>1</sub>X + &alpha;<sub>2</sub>Y + &alpha;<sub>2+j</sub>C<sub>j</sub>, }}{\eqn{logit(P(U=1)) = \alpha_0 + \alpha_1 X + \alpha_2 Y + \alpha_{2+j} C_j, }}
where \emph{U} is the binary unmeasured
confounder, \emph{X} is the exposure, \emph{Y} is the outcome, \emph{C}
represents the vector of measured confounders (if any), and \emph{j}
corresponds to the number of measured confounders. The number of parameters
therefore equals 3 + \emph{j}.}

\item{s_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(S=1)) = &beta;<sub>0</sub> + &beta;<sub>1</sub>X + &beta;<sub>2</sub>Y, }}{\eqn{logit(P(S=1)) = \beta_0 + \beta_1 X + \beta_2 Y, }}
where \emph{S} represents binary selection, \emph{X} is the exposure,
and \emph{Y} is the outcome.
The number of parameters therefore equals 3.}

\item{level}{Value from 0-1 representing the full range of the confidence
interval. Default is 0.95.}
}
\value{
A list where the first item is the odds ratio estimate of the
effect of the exposure on the outcome and the second item is the
confidence interval as the vector: (lower bound, upper bound).
}
\description{
\code{adjust_uc_sel} returns the exposure-outcome odds ratio and confidence
interval, adjusted for uncontrolled confounding and exposure
misclassificaiton.
}
\details{
Values for the regression coefficients can be applied as
fixed values or as single draws from a probability
distribution (ex: \code{rnorm(1, mean = 2, sd = 1)}). The latter has
the advantage of allowing the researcher to capture the uncertainty
in the bias parameter estimates. To incorporate this uncertainty in the
estimate and confidence interval, this function should be run in loop across
bootstrap samples of the dataframe for analysis. The estimate and
confidence interval would then be obtained from the median and quantiles
of the distribution of odds ratio estimates.
}
\examples{
adjust_uc_sel(
  df_uc_sel,
  exposure = "X",
  outcome = "Y",
  confounders = c("C1", "C2", "C3"),
  u_model_coefs = c(-0.19, 0.61, 0.72, -0.09, 0.10, -0.15),
  s_model_coefs = c(-0.01, 0.92, 0.94)
)

}
