% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domainChecks.R
\name{checkClosedUnitCube}
\alias{checkClosedUnitCube}
\title{Domain check for closed unit hypercube \eqn{[0,1]^n}}
\usage{
checkClosedUnitCube(x)
}
\arguments{
\item{x}{Matrix with numeric entries. Each row represents one point}
}
\value{
Vector where each element (TRUE or FALSE) indicates if a point is in the unit hypercube
}
\description{
The function checks if a point (one row in the input argument) is inside the closed unit hypercube \eqn{[0,1]^n} or not.
If the input matrix contains entries that are not numeric, i.e., not representing real numbers, the function throws an error.
The dimension \eqn{n} is automatically inferred from the input matrix and is equal to the number of columns.
}
\examples{
x <- matrix(rnorm(30),10,3)
checkClosedUnitCube(x)
}
