% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtag.R
\name{group}
\alias{group}
\title{Group a qualifier/tag structure}
\usage{
group(qtag, quiet = FALSE)
}
\arguments{
\item{qtag}{A qualifier/tag structure}

\item{quiet}{Pass \code{TRUE} to supress warnings on coersion to a qualifier tag structure.}
}
\value{
A \code{dplyr} grouped data frame
}
\description{
Essentially a shortcut for grouping a \link{qtag} object by its id.vars
}
\examples{
data(pocmaj)
library(dplyr)
pocmajqt <- as.qtag(pocmaj, id.vars = c("core", "depth"))
pocmajqt \%>\% group() \%>\% summarise(mean(Ca))
# equivalent to
pocmaj \%>\% group_by(core, depth) \%>\% summarise(mean(Ca))


}

