% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hvq.R
\name{hvq}
\alias{hvq}
\title{hvq}
\usage{
hvq(x, nclust = 3, depth = 3, quant.err = 10,
  algorithm = c("Hartigan-Wong", "Lloyd", "Forgy", "MacQueen"))
}
\arguments{
\item{x}{Data Frame. A dataframe of multivariate data. Each row corresponds to an
observation, and each column corresponds to a variable. Missing values are
not accepted.}

\item{nclust}{Numeric. Indicating the number of nodes per hierarchy.}

\item{depth}{Numeric. Indicating the hierarchy depth (or) the depth of the
tree (1 = no hierarchy, 2 = 2 levels, etc..)}

\item{quant.err}{Numeric. The quantization error for the algorithm.}

\item{algorithm}{String. The type of algorithm used for quantization.
Available algorithms are Hartigan and Wong, "Lloyd", "Forgy", "MacQueen".
(default is "Hartigan-Wong")}
}
\value{
\item{clusters}{ List. A list showing each ID assigned to a cluster.
} \item{nodes.clust}{ List. A list corresponding to nodes' details. }
\item{idnodes}{ List. A list of ID and segments similar to
\code{nodes.clust} with additional columns for nodes ID. }
\item{error.quant}{ List. A list of quantization error for all levels and
nodes. } \item{plt.clust}{ List. A list of logical values indicating if the
quantization error was met. } \item{zdata}{ Summary. Output table with
summary. }
}
\description{
Hierarchical Vector Quantization
}
\details{
The raw data is first scaled and this scaled data is supplied as input to
the vector quantization algorithm. Vector quantization technique uses a
parameter called quantization error. This parameter acts as a threshold and
determines the number of levels in the hierarchy. It means that, if there
are 'n' number of levels in the hierarchy, then all the clusters formed till
this level will have quantization error equal or greater than the threshold
quantization error. The user can define the number of clusters in the first
level of hierarchy and then each cluster in first level is sub-divided into
the same number of clusters as there are in the first level. This process
continues and each group is divided into smaller clusters as long as the
threshold quantization error is met. The output of this technique will be
hierarchically arranged vector quantized data.
}
\examples{

data("iris",package="datasets")
iris <- iris[,1:2]
hvqOutput = hvq(iris, nclust = 2, depth = 3, quant.err = 0.3)



}
\seealso{
\code{\link{hvtHmap}}
}
\author{
Meet K. Dave <dave.kirankumar@mu-sigma.com>
}
