% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtscr_model_summary.R
\name{mtscr_model_summary}
\alias{mtscr_model_summary}
\title{Summarise a model}
\usage{
mtscr_model_summary(model)
}
\arguments{
\item{model}{A model generated with \code{\link{mtscr_model}}. Can
be a list of models.}
}
\value{
A data frame with the following columns:
\describe{
\item{model}{The model number}
\item{nobs}{Number of observations}
\item{sigma}{The square root of the estimated residual variance}
\item{logLik}{The log-likelihood of the model}
\item{AIC}{The Akaike information criterion}
\item{BIC}{The Bayesian information criterion}
\item{df.residual}{The residual degrees of freedom}
\item{emp_rel}{The empirical reliability}
\item{FDI}{The first difference of the empirical reliability}
}
}
\description{
Summarise a model generated with \code{\link{mtscr_model}} with
some basic statistics; calculate the empirical reliability
and the first difference of the empirical reliability.
}
\examples{
data("mtscr_creativity", package = "mtscr")
mtscr_model(mtscr_creativity, id, item, SemDis_MEAN, top = 1:3) |>
  mtscr_model_summary()
}
