% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_gcode_mtc.R
\name{map_gcode_mtc}
\alias{map_gcode_mtc}
\title{Create a mapping between simulated and actual data}
\usage{
map_gcode_mtc(mtc_device_sim, mtc_device, elasticity = 2)
}
\arguments{
\item{mtc_device_sim}{is the simlated version}

\item{mtc_device}{is the actual log data}

\item{elasticity}{is the maximum consecutive reference elements skippable (passed to dtw::mvmStepPattern())}
}
\description{
Creates a timestamp based mapping to map every simulated timestamp to an actual timestamp based on real data
}
\examples{
data("example_gcode_parsed") # Parsed gcode
data("example_mtc_device_3") # MTCDevice object of actual log data
simulated_gcode_data = na.omit(simulate_data_from_gcode(example_gcode_parsed, 
start_time = 0, data_res = 0.1, data_type = "HH"))
mtc_device_sim = create_mtc_device_from_ts(simulated_gcode_data)
mtc_sim_mapped = map_gcode_mtc(mtc_device_sim, example_mtc_device_3, elasticity = 200)
}

