% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{plot.msma}
\alias{plot.msma}
\title{Plot msma}
\usage{
\method{plot}{msma}(
  x,
  v = c("weight", "score", "cpev")[1],
  axes = 1,
  block = c("block", "super")[1],
  plottype = c("bar", "scatter")[1],
  XY = c("X", "Y", "XY")[1],
  col = NULL,
  signflip = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class "\code{msma}." Usually, a result of a call to \code{\link{msma}}}

\item{v}{a character, "weight" for the weight, "score" for the score, and "cpev" for the cumulative percentage of explained variance (CPEV) .}

\item{axes}{a numeric (or vector), specifying the component(s) to plot.}

\item{block}{a character, indicating which the "block" or "super" is used.}

\item{plottype}{a character, indicating the plot type. "bar" for the bar plot, "scatter" for the scatter plot.}

\item{XY}{a character, indicating "X" or "Y". "XY" for the scatter plots using X and Y scores from PLS.}

\item{col}{a color vector.}

\item{signflip}{a logical if the sign in the block is flipped to pose the super as possitive.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
plot method for class "msma".
}
\details{
This function provides a plot of results.
}
\examples{
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

fit1 = msma(X, Y, comp=1, lambdaX=2, lambdaY=1:3)
plot(fit1)

}
