% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{cvmsma}
\alias{cvmsma}
\title{Cross-Validation}
\usage{
cvmsma(X, Y = NULL, Z = NULL, comp = 1, lambdaX, lambdaY = NULL,
  eta = 1, type = "lasso", inX = NULL, inY = NULL, muX = 0,
  muY = 0, nfold = 5, seed = 1, intseed = 1)
}
\arguments{
\item{X}{a matrix or list of matrices indicating the explanatory variable(s). This parameter is required.}

\item{Y}{a matrix or list of matrices indicating objective variable(s). This is optional. If there is no input for Y, then PCA is implemented.}

\item{Z}{a vector, response variable(s) for implementing the supervised version of (multiblock) PCA or PLS. This is optional. The length of Z is the number of subjects. If there is no input for Z, then unsupervised PLS/PCA is implemented.}

\item{comp}{numeric scalar for the number of components to be considered.}

\item{lambdaX}{numeric vector of regularized parameters for X, with a length equal to the number of blocks. If lambdaX is omitted, no regularization is conducted.}

\item{lambdaY}{numeric vector of regularized parameters for Y, with a length equal to the number of blocks. If lambdaY is omitted, no regularization is conducted.}

\item{eta}{numeric scalar indicating the parameter indexing the penalty family. This version contains only choice 1.}

\item{type}{a character, indicating the penalty family. In this version, only one choice is available: "lasso."}

\item{inX}{a vector or list of numeric vectors specifying the variables in X, always included in the model}

\item{inY}{a vector or list of numeric vectors specifying the variables in Y, always included in the model}

\item{muX}{a numeric scalar for the weight of X for the supervised case. 0 <= muX <= 1.}

\item{muY}{a numeric scalar for the weight of Y for the supervised case. 0 <= muY <= 1.}

\item{nfold}{number of folds - default is 5.}

\item{seed}{seed number for the random number in the cross-validation.}

\item{intseed}{seed number for the random number in the parameter estimation algorithm.}
}
\value{
\item{err}{The mean cross-validated errors which has three elements consisting of the mean of predict errors for X and Y, the errors for X and for Y in the PLS and only the errors for X in the PCA.}
}
\description{
Cross-validated method to evaluate the fit of msma.
}
\details{
k-fold cross-validation for \code{msma}. The evaluation is based on the matrix element-wise errors.
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### One Component CV #####
cv1 = cvmsma(X, Y, comp = 1, lambdaX=2, lambdaY=1:3, nfold=5, seed=1)
cv1

##### Two Component CV #####
cv2 = cvmsma(X, Y, comp = 2, lambdaX=2, lambdaY=1:3, nfold=5, seed=1)
cv2

}
