% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{predict.msma}
\alias{predict.msma}
\title{Prediction}
\usage{
\method{predict}{msma}(object, newX, newY = NULL, ...)
}
\arguments{
\item{object}{an object of class "\code{msma}", usually, a result of a call to \code{msma}}

\item{newX}{a matrix in which to look for variables with which to predict X required.}

\item{newY}{a matrix in which to look for variables with which to predict Y.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{X}{predicted X}

\item{Y}{predicted Y}
}
\description{
predict method for class "msma".
}
\details{
This function provide the prediction from new data based on the msma fit and is mainly used in the cross-validation
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### Two Component #####
fit2 = msma(X, Y, comp=2, lambdaX=2, lambdaY=1:3)
summary(fit2)

##### Predict #####
test = predict(fit2, newX=X, newY=Y)

}

