% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgsolve.R
\name{mrgsim_variants}
\alias{mrgsim_variants}
\alias{mrgsim_e}
\alias{mrgsim_d}
\alias{mrgsim_ei}
\alias{mrgsim_di}
\alias{mrgsim_i}
\alias{mrgsim_0}
\title{mrgsim variant functions}
\usage{
mrgsim_e(x, events, idata = NULL, data = NULL, ...)

mrgsim_d(x, data, idata = NULL, events = NULL, ...)

mrgsim_ei(x, events, idata, data = NULL, ...)

mrgsim_di(x, data, idata, events = NULL, ...)

mrgsim_i(x, idata, data = NULL, events = NULL, ...)

mrgsim_0(x, idata = NULL, data = NULL, events = NULL, ...)
}
\arguments{
\item{x}{the model object}

\item{events}{an event object}

\item{idata}{a matrix or data frame of model parameters,
one parameter per row (see \code{\link[=idata_set]{idata_set()}})}

\item{data}{NMTRAN-like data set (see \code{\link[=data_set]{data_set()}})}

\item{...}{passed to \code{\link[=update]{update()}} and
\code{\link[=do_mrgsim]{do_mrgsim()}}}
}
\description{
These functions are called by \code{\link[=mrgsim]{mrgsim()}} and have
explicit input requirements written into the function name.  The motivation
behind these variants is to give the user a clear workflow with specific,
required inputs as indicated by the function name. Use
\code{\link[=mrgsim_q]{mrgsim_q()}} instead to benchmark mrgsolve or to do repeated quick
simulation for tasks like parameter optimization,  sensitivity analyses,
or optimal design.
}
\details{
\strong{Important}: all of these functions require that
\code{data}, \code{idata}, and/or \code{events} be pass directly to the functions.  They
will not recognize these inputs from a pipeline.
\itemize{
\item \code{mrgsim_e} simulate using an event object
\item \code{mrgsim_ei} simulate using an event object and \code{idata_set}
\item \code{mrgsim_d} simulate using a \code{data_set}
\item \code{mrgsim_di} simulate using a \code{data_set} and  \code{idata_set}
\item \code{mrgsim_i} simulate using a \code{idata_set}
\item \code{mrgsim_0} simulate using just the model
\item \code{mrgsim_q} simulate from a data set with quicker turnaround (see
\code{\link[=mrgsim_q]{mrgsim_q()}})
}
}
\seealso{
\code{\link[=mrgsim]{mrgsim()}}, \code{\link[=mrgsim_q]{mrgsim_q()}}, \code{\link[=qsim]{qsim()}}
}
