% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chain.R
\name{tscale}
\alias{tscale}
\title{Rescale time in the simulated output}
\usage{
tscale(x, value = 1, ...)
}
\arguments{
\item{x}{model object}

\item{value}{value by which time will be scaled}

\item{...}{passed along}
}
\description{
Rescale time in the simulated output
}
\details{
There is also a \code{tscale} argument to \code{\link{mrgsim}} that can 
be set to accomplish the same thing as a call to \code{tscale} in 
the pipeline.
}
\examples{
# The model is in hours:
mod <- mrgsolve:::house()

# The output is in days:
mod \%>\% tscale(1/24) \%>\% mrgsim

}
