% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locker.R
\name{reset_locker}
\alias{reset_locker}
\title{Initialize the locker directory}
\usage{
reset_locker(where, pattern = NULL)
}
\arguments{
\item{where}{The full path to the locker.}

\item{pattern}{A regular expression for finding files to clear from the
locker directory.}
}
\description{
This function is called by \code{\link[=setup_locker]{setup_locker()}} to initialize and
re-initialize a locker directory. We call it \code{reset_locker} because it is
expected that the locker space is created once and then repeatedly
reset and simulations are run and re-run.
}
\details{
For the locker space to be initialized, the \code{where} directory must not
exist; if it exists, there will be an error. It is also an error for
\code{where} to exist and not contain a particular hidden locker file name
that marks the directory as established locker space.

\strong{NOTE}: when the locker is reset, all contents are cleared according
to the files matched by \code{pattern}. If any un-matched files exist after
clearing the directory, a warning will be issued.
}
\seealso{
\code{\link[=setup_locker]{setup_locker()}}, \code{\link[=noreset_locker]{noreset_locker()}}, \code{\link[=version_locker]{version_locker()}}
}
