% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpp_back_elim.R
\name{mpp_back_elim}
\alias{mpp_back_elim}
\title{Backward elimination on QTL candidates}
\usage{
mpp_back_elim(mppData, trait = 1, QTL = NULL, Q.eff = "cr", alpha = 0.05)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected position obtained with the function \code{\link{QTL_select}} or
vector of \code{character} marker positions names.
Default = NULL.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effects: 1) "cr" for cross-specific; 2) "par" for parental; 3) "anc"
for ancestral; 4) "biall" for a bi-allelic. For more details see
\code{\link{mpp_SIM}}. Default = "cr".}

\item{alpha}{\code{Numeric} value indicating the level of significance for
the backward elimination. Default = 0.05.}
}
\value{
Return:

\item{QTL }{\code{Data.frame} of class \code{QTLlist} with five columns :
1) QTL marker names; 2) chromosomes;
3) interger position indicators on the chromosome;
4) positions in centi-Morgan; and 5) -log10(p-values).}
}
\description{
Performs a backward elimination using a list of given QTLs positions. The
positions with a p-value above the significance level \code{alpha}, are
successively removed.
}
\details{
The function starts with all QTL positions in the model and test the inclusion
of each position as the last in the model. If all position p-values are below
\code{alpha} the procedure stop. If not the position with the highest p-value
is remove and the procedure continue until there is no more unsignificant
position.
}
\examples{

data(mppData)

SIM <- mpp_SIM(mppData)

QTL <- QTL_select(SIM)

QTL.sel <- mpp_back_elim(mppData = mppData, QTL = QTL)

}
\seealso{
\code{\link{mpp_SIM}}
}
\author{
Vincent Garin
}
