% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.mppData.R
\name{subset.mppData}
\alias{subset.mppData}
\title{Subset \code{mppData} object}
\usage{
\method{subset}{mppData}(x, mk.list = NULL, gen.list = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{mppData}.}

\item{mk.list}{Optional \code{character} vector, \code{numeric} position
vector or \code{logical} vector representing marker to keep. Default = NULL.}

\item{gen.list}{Optional \code{character} vector, \code{numeric} position
vector or \code{logical} vector representing genotypes to keep.
Default = NULL.}

\item{...}{Ignored.}
}
\value{
Return:

The mppData object but with only the specified subset of data.
}
\description{
Pull out a specified set of markers and/or genotypes from a \code{mppData}
object.
}
\examples{

### Marker subset

data(mppData)

# Random selection of markers
mk.list <-  sample(mppData$map[, 1], 50)
mppData_sub <- subset(x = mppData, mk.list = mk.list)

# Selection of chromosome 1 marker
mk.list <-  (mppData$map[, 2] == 1)
mppData_sub <- subset(x = mppData, mk.list = mk.list)

### Genotype subset

# Random selection of genotypes
gen.list <-  sample(mppData$geno.id, 200)
mppData_sub <- subset(x = mppData, gen.list = gen.list)

# Selection of genotype from cross 2 and 5
crosses <- unique(mppData$cross.ind)
gen.list <-  mppData$geno.id[mppData$cross.ind \%in\% crosses[c(2, 5)]]
mppData_sub <- subset(x = mppData, gen.list = gen.list)

### Marker and genotype subset

mk.list <-  sample(mppData$map[, 1], 50)
gen.list <-  sample(mppData$geno.id, 200)
mppData_sub <- subset(x = mppData, mk.list = mk.list,
gen.list = gen.list)

}
\author{
Vincent Garin
}
