% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezier.R
\name{bezierFunction}
\alias{bezierFunction}
\title{Bezier function}
\usage{
bezierFunction(points, weights = rep(1L, nrow(points)))
}
\arguments{
\item{points}{a matrix or data frame of numerics.  the rows
represent points.}

\item{weights}{the weights in a weighted Bezier curve}
}
\value{
function of a single parameter
}
\description{
Compute the Bezier function of a collection of polynomials.  By
Bezier function we mean the Bezier curve function, a parametric
map running from t = 0, the first point, to t = 1, the last
point, where the coordinate mappings are linear combinations of
Bernstein polynomials.
}
\details{
The function returned is vectorized and evaluates the Bezier
curve in a numerically stable way with de Castlejau's algorithm
(implemented in R).
}
\examples{

library(ggplot2); theme_set(theme_bw())


t <- seq(0, 1, length.out = 201)
points <- data.frame(x = 0:3, y = c(0,1,-1,0))


f <- bezierFunction(points)
df <- as.data.frame(f(t))

ggplot(aes(x = x, y = y), data = df) + 
  geom_point(data = points, color = "red", size = 8) +
  geom_path(data = points, color = "red") +
  geom_path()
  
  
  
  
f <- bezierFunction(points, weights = c(1,5,5,1))
df <- as.data.frame(f(t))

ggplot(aes(x = x, y = y), data = df) + 
  geom_point(data = points, color = "red", size = 8) +
  geom_path(data = points, color = "red") +
  geom_path()
  
  
  
  
f <- bezierFunction(points, weights = c(1,10,10,1))
df <- as.data.frame(f(t))

ggplot(aes(x = x, y = y), data = df) + 
  geom_point(data = points, color = "red", size = 8) +
  geom_path(data = points, color = "red") +
  geom_path()
  
  
  
  
  
  
  
  
  
  

}
\references{
\url{http://en.wikipedia.org/wiki/Bezier_curve}, 
  \url{http://en.wikipedia.org/wiki/De_Casteljau's_algorithm}
}
\seealso{
\code{\link{bezier}}
}
\author{
David Kahle
}
