% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/af.R
\name{plot.af}
\alias{plot.af}
\title{Plot diagnostics for an af object}
\usage{
\method{plot}{af}(
  x,
  pch,
  interactive = FALSE,
  classic = NULL,
  tag = NULL,
  shiny = FALSE,
  best.only = FALSE,
  width = 800,
  height = 400,
  fontSize = 12,
  left = 50,
  top = 30,
  chartWidth = "60\%",
  chartHeight = "80\%",
  backgroundColor = "transparent",
  legend.position = "top",
  model.wrap = NULL,
  legend.space = NULL,
  options = NULL,
  ...
)
}
\arguments{
\item{x}{\code{af} object, the result of \code{\link{af}}}

\item{pch}{plotting character, i.e., symbol to use}

\item{interactive}{logical.  If \code{interactive=TRUE} a
googleVis plot is provided instead of the base graphics plot.
Default is \code{interactive=FALSE}.}

\item{classic}{logical.  Depricated. If \code{classic=TRUE} a
base graphics plot is provided instead of a googleVis plot.
For now specifying \code{classic} will overwrite the
default \code{interactive} behaviour, though this is
likely to be removed in the future.}

\item{tag}{Default NULL. Name tag of the objects to be extracted
from a gvis (googleVis) object.

The default tag for is NULL, which will
result in R opening a browser window.  Setting \code{tag='chart'}
or setting \code{options(gvis.plot.tag='chart')} is useful when
googleVis is used in scripts, like knitr or rmarkdown.}

\item{shiny}{Default FALSE. Set to TRUE when using in a shiny interface.}

\item{best.only}{logical determining whether the output used the
standard fence approach of only considering the best models
that pass the fence (\code{TRUE}) or if it should take into
account all models that pass the fence at each boundary
value (\code{FALSE}).}

\item{width}{Width of the googleVis chart canvas area, in pixels.
Default: 800.}

\item{height}{Height of the googleVis chart canvas area, in pixels.
Default: 400.}

\item{fontSize}{font size used in googleVis chart.  Default: 12.}

\item{left}{space at left of chart (pixels?).  Default: "50".}

\item{top}{space at top of chart (pixels?).  Default: "30".}

\item{chartWidth}{googleVis chart area width.
A simple number is a value in pixels;
a string containing a number followed by \code{\%} is a percentage.
Default: \code{"60\%"}}

\item{chartHeight}{googleVis chart area height.
A simple number is a value in pixels;
a string containing a number followed by \code{\%} is a percentage.
Default: \code{"80\%"}}

\item{backgroundColor}{The background colour for the main area
of the chart. A simple HTML color string,
for example: 'red' or '#00cc00'.  Default: 'transparent'}

\item{legend.position}{legend position, e.g. \code{"topleft"}
or  \code{"bottomright"}}

\item{model.wrap}{Optional parameter to split the legend names
if they are too long for classic plots.  \code{model.wrap=2}
means that there will be two variables per line,  \code{model.wrap=2}
gives three variables per line and \code{model.wrap=4} gives 4
variables per line.}

\item{legend.space}{Optional parameter to add additional space
between the legend items for the classic plot.}

\item{options}{If you want to specify the full set of googleVis
options.}

\item{...}{further arguments (currently unused)}
}
\description{
Summary plot of the bootstrap results of an af object.
}
\details{
For each value of \eqn{c}{c} a parametric
bootstrap is performed under the full model.
For each bootstrap
sample we identify the smallest model inside the fence,
\eqn{\hat{\alpha}(c)}{hat{alpha}(c)}.   We calculate the empirical probability of selecting
model \eqn{\alpha}{alpha} for a given value of \eqn{c}{c} as
\deqn{p^*(c,\alpha)=P^*\{\hat{\alpha}(c)=\alpha\}.}{p*(c,alpha)=P*{hat{alpha}(c)=alpha}.}
Hence, if \eqn{B}{B} bootstrap replications are performed,
\eqn{p^*(c,\alpha)}{p^*(c,alpha)} is the
proportion of times that model \eqn{\alpha}{alpha} is selected.  Finally,
define an overall selection probability,
\deqn{p^*(c)=\max_{\alpha\in\mathcal{A}}p^*(c,\alpha)}{p*(c)=max_{alpha in mathcal{A}}p*(c,alpha)} and we plot
\eqn{p^*(c)}{p*(c)} against \eqn{c}{c}. The points on the scatter plot are
colour coded by the model that yielded the highest inclusion probability.
}
