% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_extract.R
\name{predict.cmp}
\alias{predict.cmp}
\title{Model Predictions for a \code{glm.cmp} Object}
\usage{
\method{predict}{cmp}(
  object,
  newdata = NULL,
  se.fit = FALSE,
  type = c("link", "response"),
  ...
)
}
\arguments{
\item{object}{an object class 'cmp', obtained from a call to \code{glm.cmp}.}

\item{newdata}{optionally, a data frame in which to look for variables with which to
predict. If omitted, the fitted linear predictors are used.}

\item{se.fit}{logical; indicating if standard errors are required.}

\item{type}{the type of prediction required. The default is 'link' which is the scale
of the linear predictor i.e., a log scale; the alternative 'response' is on the scale
of the response variable. The value of this argument can be abbreviated.}

\item{...}{other arguments passed to or from other methods  (currently unused).}
}
\value{
If \code{se.fit = FALSE}, a vector of predictions.

If \code{se.fit = TRUE}, a list with components
\item{fit}{Predictions, as for se.fit = FALSE.}
\item{se.fit}{Estimated standard errors.}
}
\description{
This is a function for obtaining predictions and optionally estimates standard
errors of those prediction from a fitted COM-Poisson regression object.
}
\details{
If newdata is omitted the predictions are based on the data used for the fit.
}
\examples{
data(takeoverbids)
M.bids <- glm.cmp(numbids ~ leglrest + rearest + finrest + whtknght 
    + bidprem + insthold + size + sizesq + regulatn, data=takeoverbids)

predict(M.bids)
predict(M.bids, type= "response")
predict(M.bids, se.fit=TRUE, type="response")

newdataframe <- data.frame(bidprem = 1, finrest = 0, insthold = 0.05,
    leglrest = 0, rearest = 1, regulatn = 0, size = 0.1, whtknght = 1, 
    sizesq = .1^2)
predict(M.bids, se.fit=TRUE, newdata = newdataframe, type="response")
}
