% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.cmp.R
\name{glm.cmp}
\alias{glm.cmp}
\title{Fit a Mean Parametrized Conway-Maxwell-Poisson Generalized Linear Model}
\usage{
glm.cmp(formula, data, offset = NULL,
   lambdalb = 1e-10, lambdaub = 1900, maxlambdaiter = 1e3, tol = 1e-6)
}
\arguments{
\item{formula}{an object of class 'formula': a symblic desciption of the model to be 
fitted.}

\item{data}{an optional data frame containing the variables in the model}

\item{offset}{this can be used to specify an *a priori* known component to be included 
in the linear predictor during fitting. This should be \code{NULL} or a numeric vector 
of length equal to the number of cases.}

\item{lambdalb, lambdaub}{numeric: the lower and upper end points for the interval to be
searched for lambda(s). The default value for lambdaub should be sufficient for small to
moderate size nu. If nu is large and required a larger \code{lambdaub}, the algorithm
will scale up \code{lambdaub} accordingly.}

\item{maxlambdaiter}{numeric: the maximum number of iterations allowed to solve 
for lambda(s).}

\item{tol}{numeric: the convergence threshold. A lambda is said to satisfy the 
mean constraint if the absolute difference between the calculated mean and a fitted
values is less than tol.}
}
\value{
A fitted model object of class \code{cmp} similar to one obtained from \code{glm} 
or \code{glm.nb}.

The function \code{summary} (i.e., \code{\link{summary.cmp}}) can be used to obtain 
and print a summary of the results. 

The function \code{plot} (i.e., \code{\link{plot.cmp}}) can be used to produce a range 
of diagnostic plots. 

The generic assessor functions \code{coef} (i.e., \code{\link{coef.cmp}}), 
\code{logLik} (i.e., \code{\link{logLik.cmp}}) 
\code{fitted} (i.e., \code{\link{fitted.cmp}}), 
\code{nobs} (i.e., \code{\link{nobs.cmp}}), 
\code{AIC} (i.e., \code{\link{AIC.cmp}}) and 
\code{residuals} (i.e., \code{\link{residuals.cmp}}) 
can be used to extract various useful features of the value
returned by \code{glm.cmp}.

An object class 'glm.cmp' is a list containing at least the following components:

\item{coefficients}{a named vector of coefficients}
\item{se_beta}{approximate standard errors (using observed rather than expected 
information) for coefficients}
\item{residuals}{the \emph{response} residuals (i.e., observed-fitted)}
\item{fitted.values}{the fitted mean values}
\item{rank}{the numeric rank of the fitted linear model}
\item{linear.predictors}{the linear fit on log scale}
\item{df.residuals}{the residuals degrees of freedom}
\item{df.null}{the residual degrees of freedom for the null model}
\item{null.deviance}{The deviance for the null model. 
The null model will include only the intercept.}
\item{y}{the \code{y} vector used.}
\item{x}{the model matrix}
\item{model}{the model frame}
\item{call}{the matched call}
\item{formula}{the formula supplied}
\item{terms}{the \code{terms} object used}
\item{data}{the \code{data} argument}
\item{offset}{the \code{offset} vector used}
\item{lambdaub}{the final \code{lambdaub} used}
}
\description{
The function \code{glm.cmp} is used to fit a mean parametrized Conway-Maxwell-Poisson
generalized linear model with a log-link by using Fisher Scoring iteration.
}
\details{
Fit a mean parametrizied COM-Poisson regression using maximum likelihood estimation 
via an iterative Fisher Scoring algorithm. 

The COM-Poisson regression model is

Y_i ~ CMP(mu_i, nu), 
          
where  
   
E(Y_i) = mu_i = exp(x_i^T beta),
      
and \emph{nu > 0} is the dispersion parameter. 

The fitted COM-Poisson distribution is over- or under-dispersed 
if \emph{nu < 1} and \emph{nu > 1} respectively.
}
\examples{
### Huang (2017) Page 368--370: Overdispersed Attendance data
\donttest{
data(attendance)
M.attendance <- glm.cmp(daysabs~ gender+math+prog, data=attendance)
M.attendance
summary(M.attendance)
}

### Huang (2017) Page 371--372: Underdispersed Takeover Bids data
data(takeoverbids)
M.bids <- glm.cmp(numbids ~ leglrest + rearest + finrest + whtknght 
    + bidprem + insthold + size + sizesq + regulatn, data=takeoverbids)
    M.bids
summary(M.bids)

### Huang (2017) Page 373--375: Underdispersed Cotton bolls data
### Model fitting for predictor V 
\donttest{
data(cottonbolls)
M.bolls <- glm.cmp(nc~ 1+stages:def+stages:def2, data= cottonbolls)
M.bolls
summary(M.bolls)
}
}
\references{
Fung, T., Alwan, A., Wishart, J. and Huang, A. (2018). The \code{mpcmp} package for 
Mean-parametrized Conway-Maxwell-Poisson Regression. 

Huang, A. (2017). Mean-parametrized Conway–Maxwell–Poisson regression models for 
dispersed counts. \emph{Statistical Modelling} \bold{17}, 359--380.
}
\seealso{
\code{\link{summary.cmp}}, \code{\link{plot.cmp}}, \code{\link{fitted.cmp}} 
and \code{\link{residuals.cmp}}.
}
