% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripPedigree.R
\name{stripPedigree}
\alias{stripPedigree}
\title{Strip pedigree of unneccessary lines}
\usage{
stripPedigree(pedigree, finalLines)
}
\arguments{
\item{pedigree}{The initial pedigree, which may contain some unneccessary extra genetic lines}

\item{finalLines}{The list of lines of interest. Lines in the pedigree which do not make a genetic contribution to the lines in \code{finalLines} will be removed.}
}
\value{
An object of class \code{detailedPedigree} representing the experimental design, suitable for simulation using simulateMPCross.
}
\description{
Strip pedigree of lines that make no genetic contribution to the specified set of lines.
}
\details{
Pedigrees for structured experiments can be messy. Often they include lines that make no genetic contribution to the lines that were finally genotyped. When it comes to visualising the structure of the pedigree of the final population, these unneccessary extra lines can make it difficult to see the structure. This function takes in a pedigree and a list of genetic lines, and returns a subpedigree that contains only those lines that make a genetic contribution to the named lines.

This function relies on the use of the Boost C++ libraries, and may not be available in every distributed version of mpMap2. If this function is unavailable, the function will return \code{NULL}.
}
