# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Gamma density function
#'
#' Probability density function of the gamma distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param mu Mean
#' @param sigma Standard deviation
#'
#' @return Vector of densities
dgamma_rcpp <- function(x, mu, sigma) {
    .Call('moveHMM_dgamma_rcpp', PACKAGE = 'moveHMM', x, mu, sigma)
}

#' Weibull density function
#'
#' Probability density function of the Weibull distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param shape Shape
#' @param scale Scale
#'
#' @return Vector of densities
dweibull_rcpp <- function(x, shape, scale) {
    .Call('moveHMM_dweibull_rcpp', PACKAGE = 'moveHMM', x, shape, scale)
}

#' Log-normal density function
#'
#' Probability density function of the log-normal distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param meanlog Mean of the distribution on the log-scale
#' @param sdlog Standard deviation of the distribution on the log-scale
#'
#' @return Vector of densities
dlnorm_rcpp <- function(x, meanlog, sdlog) {
    .Call('moveHMM_dlnorm_rcpp', PACKAGE = 'moveHMM', x, meanlog, sdlog)
}

#' Exponential density function
#'
#' Probability density function of the exponential distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param rate Rate
#' @param foo Unused (for compatibility with template)
#'
#' @return Vector of densities
dexp_rcpp <- function(x, rate, foo = 0) {
    .Call('moveHMM_dexp_rcpp', PACKAGE = 'moveHMM', x, rate, foo)
}

#' Von Mises density function
#'
#' Probability density function of the Von Mises distribution, defined as a function
#' of the modified Bessel function of order 0 (written in C++)
#'
#' @param x Vector of quantiles
#' @param mu Mean
#' @param kappa Concentration
#'
#' @return Vector of densities
dvm_rcpp <- function(x, mu, kappa) {
    .Call('moveHMM_dvm_rcpp', PACKAGE = 'moveHMM', x, mu, kappa)
}

#' Wrapped Cauchy density function
#'
#' Probability density function of the wrapped Cauchy distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param mu Mean
#' @param rho Concentration
#'
#' @return Vector of densities
dwrpcauchy_rcpp <- function(x, mu, rho) {
    .Call('moveHMM_dwrpcauchy_rcpp', PACKAGE = 'moveHMM', x, mu, rho)
}

#' Negative log-likelihood
#'
#' Computation of the negative log-likelihood (forward algorithm - written in C++)
#'
#' @param nbStates Number of states
#' @param beta Matrix of regression coefficients for the transition probabilities
#' @param covs Covariates
#' @param data A \code{\link{moveData}} object of the observations
#' @param stepDist The name of the step length distribution
#' @param angleDist The name of the turning angle distribution
#' @param stepPar State-dependent parameters of the step length distribution
#' @param anglePar State-dependent parameters of the turning angle distribution
#' @param delta Stationary distribution
#' @param aInd Vector of indices of the rows at which the data switches to another animal
#' @param zeroInflation \code{true} if zero-inflation is included in the step length distribution,
#' \code{false} otherwise.
#' @param stationary \code{false} if there are covariates. If \code{true}, the initial distribution
#' is considered equal to the stationary distribution.
#' @param knownStates Vector of values of the state process which are known prior to fitting the
#' model (if any). Default: NULL (states are not known). This should be a vector with length the number
#' of rows of 'data'; each element should either be an integer (the value of the known states) or NA if
#' the state is not known.
#'
#' @return Negative log-likelihood
nLogLike_rcpp <- function(nbStates, beta, covs, data, stepDist, angleDist, stepPar, anglePar, delta, aInd, zeroInflation, stationary, knownStates) {
    .Call('moveHMM_nLogLike_rcpp', PACKAGE = 'moveHMM', nbStates, beta, covs, data, stepDist, angleDist, stepPar, anglePar, delta, aInd, zeroInflation, stationary, knownStates)
}

#' Transition probability matrix
#'
#' Computation of the transition probability matrix, as a function of the covariates and the regression
#' parameters. Written in C++. Used in \code{\link{viterbi}}.
#'
#' @param nbStates Number of states
#' @param beta Matrix of regression parameters
#' @param covs Matrix of covariate values
#'
#' @return Three dimensional array \code{trMat}, such that \code{trMat[,,t]} is the transition matrix at
#' time t.
trMatrix_rcpp <- function(nbStates, beta, covs) {
    .Call('moveHMM_trMatrix_rcpp', PACKAGE = 'moveHMM', nbStates, beta, covs)
}

