% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{moveplot}
\alias{moveplot}
\title{Move plot}
\usage{
moveplot(bp, time.var, group.var, move = TRUE, hulls = TRUE, scale.var = 5)
}
\arguments{
\item{bp}{biplot object from biplotEZ}

\item{time.var}{time variable}

\item{group.var}{group variable}

\item{move}{whether to animate (TRUE) or facet (FALSE) samples, according to time.var}

\item{hulls}{whether to display sample points or convex hulls}

\item{scale.var}{scaling the vectors representing the variables}
}
\value{
An animated or a facet of biplots based on the fixed variable frame.
}
\description{
Create animated biplot on samples in a biplot
}
\examples{
data(Africa_climate)
bp <- biplotEZ::biplot(Africa_climate, scaled = TRUE) |> biplotEZ::PCA()
bp |> moveplot(time.var = "Year", group.var = "Region", hulls = TRUE, move = FALSE)
bp |> moveplot(time.var = "Year", group.var = "Region", hulls = FALSE, move = FALSE)
\donttest{
if(interactive()) {
bp |> moveplot(time.var = "Year", group.var = "Region", hulls = TRUE, move = TRUE)}}
}
