% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{mt_standardize}
\alias{mt_standardize}
\title{Standardize mouse-tracking measures per level of other variables.}
\usage{
mt_standardize(data, use = "measures", use_variables = NULL,
  within = NULL, prefix = "z_", center = TRUE, scale = TRUE)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details).}

\item{use}{a character string specifying which data should be used. By
default points to the \code{measures} data.frame created using
\link{mt_measures}.}

\item{use_variables}{a vector specifying which variables should be
standardized. If unspecified, all variables will be standardized.}

\item{within}{an optional character string specifying one or more variables
in \code{data[["data"]]}. If specified, all measures will be standardized
separately for each level of the variable (or for each combination of
levels, if more than one variable is specified).}

\item{prefix}{a character string that is inserted before each standardized
variable. If an empty string is specified, the original variables are
replaced.}

\item{center}{argument passed on to \link{scale}.}

\item{scale}{argument passed on to \link{scale}.}
}
\value{
A mousetrap data object (see \link{mt_example})
including the standardized measures.
}
\description{
Standardize selected mouse-tracking measures across all trials or per level
of one or more other variable, and store them in new variables. This function
is a thin wrapper around \link{scale_within}, focussed on mouse-tracking data
stored in a mousetrap data object.
}
\examples{
mt_example <- mt_measures(mt_example)

# Standardize MAD and AD per subject
mt_example <- mt_standardize(mt_example,
  use_variables=c("MAD", "AD"),
  within="subject_nr", prefix="z_")

# Standardize MAD and AD per subject and Condition
mt_example <- mt_standardize(mt_example,
  use_variables=c("MAD", "AD"),
  within=c("subject_nr", "Condition"),
  prefix="z_")
  
}
\seealso{
\link{mt_scale_trajectories} for standardizing variables in mouse
  trajectory arrays.

  \link{scale_within} which is called by \code{mt_standardize}.

  \link{scale} for the R base scale function.
}
\author{
Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})

Felix Henninger
}
