% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{scale_within}
\alias{scale_within}
\title{Scale and center variables within the levels of another variable.}
\usage{
scale_within(data, variables = NULL, within = NULL, prefix = "",
  center = TRUE, scale = TRUE)
}
\arguments{
\item{data}{a \link{data.frame}.}

\item{variables}{a character string (or vector) specifying one or more
variables that \link{scale} is applied to. If unspecified,
\code{scale_within} will be applied to all variables in data.}

\item{within}{an optional character string specifying the name of one or more
variables in \code{data}. If specified, \link{scale} is applied separately 
for each of the levels of the variable (or for each combination of levels,
if more than one variable is specified). Alternatively, a vector directly
containing the level values.}

\item{prefix}{a character string that is inserted before each scaled
variable. By default (empty string) the original variables are replaced.}

\item{center}{argument passed on to \link{scale}.}

\item{scale}{argument passed on to \link{scale}.}
}
\value{
The original data.frame including the centered and / or scaled
  variables.
}
\description{
\code{scale_within} centers and/or scales variables in a data.frame (using 
\link{scale}) depending on the levels of one or more other variables. By 
default, variables are standardized (i.e., centered and scaled). A typical 
application is the within-subject standardization of variables in a repeated 
measures design.
}
\examples{
ChickWeight_scaled <-  scale_within(
 ChickWeight, variables="weight",
 within="Chick", prefix="z_")
 
}
\seealso{
\link{scale} for the R base scale function.

\link{mt_standardize} for standardizing measures in a mousetrap data object.
}
\author{
Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})

Felix Henninger
}
