% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortTraitData.R
\name{sortTraitData}
\alias{sortTraitData}
\title{Sort data and remove missing entries for tree and trait data}
\usage{
sortTraitData(phy, y, log.trait = TRUE)
}
\arguments{
\item{phy}{An object of class "phylo" or "multiPhylo" (see ape package).}

\item{y}{A matrix of trait values with taxon names as rownames. Missing values should be NA}

\item{log.trait}{Logical. If TRUE, data are log-transformed}
}
\value{
phy Tree with missing data pruned

trait Rearranged data with missing species removed
}
\description{
Plots a phylogeny with lines representing the value of a continuous trait
}
\examples{
data(anolis.tree)
data(anolis.data)
attach(anolis.data)
male.length <- matrix(Male_SVL, dimnames=list(rownames(anolis.data)))
any(is.na(male.length[,1]))
data.sorted <- sortTraitData(anolis.tree, male.length)
phy <- data.sorted[[1]]
male.length <- data.sorted[[2]]
}
\author{
Mark Puttick
}
