% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetsDoc.R
\docType{data}
\name{RailTrail}
\alias{RailTrail}
\title{Volume of Users of a Rail Trail}
\format{A data frame with 90 observations on the following variables.
  \itemize{
    \item{\code{hightemp}} {daily high temperature (in degrees Fahrenheit)}
    \item{\code{lowtemp}} {daily low temperature (in degrees Fahrenheit)}
    \item{\code{avgtemp}} {average of daily low and daily high temperature (in degrees Fahrenheit)}
    \item{\code{spring}} {indicator of whether the season was Spring}
    \item{\code{summer}} {indicator of whether the season was Summer}
    \item{\code{fall}} {indicator of whether the season was Fall}
    \item{\code{cloudcover}} {measure of cloud cover (in oktas)}
    \item{\code{precip}} {measure of precipitation (in inches)}
    \item{\code{volume}} {estimated number of trail users that day (number of breaks recorded)}
    \item{\code{weekday}} {logical indicator of whether the day was a non-holiday weekday}
    \item{\code{dayType}} {one of "weekday" or "weekend"}
  }}
\source{
Pioneer Valley Planning Commission
}
\usage{
data(RailTrail)
}
\description{
The Pioneer Valley Planning Commission (PVPC) collected data north of Chestnut Street in 
Florence, MA for ninety days from April 5, 2005 to November 15, 2005. Data collectors set up a 
laser sensor, with breaks in the laser beam recording when a rail-trail user passed the 
data collection station.
}
\details{
There is a potential for error when two users trigger the infrared beam at exactly the same time since the counter 
would only logs one of the crossings.  The collectors left the motion detector out during the winter, but because the 
counter drops data when the temperature falls below 14 degrees Fahrenheit, there is no data for the cold winter months.
}
\examples{
data(RailTrail)

}
\references{
http://www.fvgreenway.org/pdfs/Northampton-Bikepath-Volume-Counts%20_05_LTA.pdf
}
