% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval-statistics.R
\name{coverage}
\alias{coverage}
\alias{interval_statistics}
\alias{ci.mean}
\alias{ci.median}
\alias{ci.sd}
\alias{ci.prop}
\title{Interval statistics}
\usage{
coverage(x, level = 0.95, na.rm = TRUE)

ci.mean(x, level = 0.95, na.rm = TRUE)

ci.median(x, level = 0.9, na.rm = TRUE)

ci.sd(x, level = 0.95, na.rm = TRUE)

ci.prop(x, success = NULL, level = 0.95, method = c("Clopper-Pearson",
  "binom.test", "Score", "Wilson", "prop.test", "Wald", "Agresti-Coull",
  "Plus4"))
}
\arguments{
\item{x}{a variable.}

\item{level}{number in 0 to 1 specifying the confidence level for the interval. (Default: 0.95)}

\item{na.rm}{if \code{TRUE} disregard missing data}

\item{success}{for proportions, this specifies the categorical level for which the calculation of proportion will
be done. Defaults: \code{TRUE} for logicals for which the proportion is to
be calculated.}

\item{method}{for \code{ci.prop()}, the method to use in calculating the confidence
interval. See \code{mosaic::binom.test()} for details.}
}
\value{
a named numerical vector with components \code{lower} and \code{upper}, and,
in the case of \code{ci.prop()}, \code{center}. When used the \code{df_stats()}, these components
are formed into a data frame.
}
\description{
Calculate coverage intervals and confidence intervals for the sample mean, median, sd, proportion, ...
Typically, these will be used within \code{df_stats()}. For the mean, median, and sd, the variable x must be
quantitative. For proportions, the x can be anything; use the \code{success} argument to specify what
value you want the proportion of. Default for \code{success} is \code{TRUE} for x logical, or the first level returned
by \code{unique} for categorical or numerical variables.
}
\details{
Methods: \code{ci.mean()} uses the standard t confidence interval.
\code{ci.median()} uses the normal approximation method.
\code{ci.sd()} uses the chi-squared method.
\code{ci.prop()} uses the binomial method. In the usual situation where the \code{mosaic} package is available,
\code{ci.prop()} uses \code{mosaic::binom.test()} internally, which provides several
methods for the calculation. See the documentation
for \code{binom.test()} for details about the available methods. Clopper-Pearson is
the default method. When used with \code{df_stats()}, the confidence interval
is calculated for each group separately. For "pooled" confidence intervals, see methods
such as \code{lm()} or \code{glm()}.
}
\note{
When using these functions with \code{df_stats()}, omit the \code{x} argument, which
will be supplied automatically by \code{df_stats()}. See examples.
}
\examples{
# The central 95\% interval
df_stats(hp ~ cyl, data = mtcars, c95 = coverage(0.95))
# The confidence interval on the mean
df_stats(hp ~ cyl, data = mtcars, mean, ci.mean)
# What fraction of cars have 6 cylinders?
df_stats(mtcars, ~ cyl, six_cyl_prop = ci.prop(success = 6, level = 0.90))
# Use without `df_stats()` (rare)
ci.mean(mtcars$hp)

}
\seealso{
\code{\link[mosaicCore:df_stats]{mosaicCore::df_stats()}}, \code{\link[mosaic:binom.test]{mosaic::binom.test()}}, \code{\link[mosaic:t.test]{mosaic::t.test()}}
}
\keyword{stats}
