% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{bounds}
\alias{bounds}
\alias{domain}
\title{Specify a domain over which a function is to be graphed}
\usage{
bounds(...)

domain(...)
}
\arguments{
\item{\dots}{One or more expression of the form x=-5:5}
}
\description{
domain() is used with slice_plot(), contour_plot(), or interactive_plot()
to describe the plotting region. There is a standard syntax for
domain() (see the first example) but there are also shortcuts.
In the shorthand syntaxes, you can but don't have to specify the name of
the input. If it's not specified, the plotting programs will try
to do something sensible. But better to specify the names explicitly.
}
\examples{
\dontrun{
contour_plot(x / y ~ x + y, bounds(x=-5:5, y=1:4))
slice_plot(x^2 ~ x, bounds(x = 2.5:4.2)) # overrides colon operator
slice_plot(x^2 ~ x, bounds(x = c(2.5, 4.2)))
slice_plot(x^2 ~ x, bounds(x = 1 \%pm\% 0.5))
}

}
